/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.swing.ConfigurableListCellRenderer;
import com.glaivestone.mv.swing.ValueRenderer;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.ussamasters.aces.tools.foundation.settings.WorkingSetSettings;
import org.ussamasters.aces.tools.ui.swing.RaceSeriesIdentificationPanel;

public class RaceSeriesDefinitionPanel
extends RaceSeriesIdentificationPanel {
    public static final float DEFAULT_HEIGHT_TWIPS = 810.0f;
    public static final ValueRenderer WORKING_SET_RENDERER = new ValueRenderer(){

        @Override
        public String toDisplayString(Object aValue) {
            return ((WorkingSetSettings)aValue).getDescription();
        }
    };
    protected List<WorkingSetSettings> workingSets;
    protected DefaultComboBoxModel<WorkingSetSettings> workingSetsHolder;
    protected JLabel raceSeriesNameLabel;
    protected JComboBox<WorkingSetSettings> workingSetsComboBox;
    protected JButton newWorkingSetButton;
    protected JButton editConfigSettingsButton;
    protected DefaultComboBoxModel<String> raceSeriesNamesHolder;

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected void initSelf() {
        super.initSelf();
    }

    @Override
    protected void initRaceSeriesIdentificationItems() {
        this.raceSeriesNameLabel = new JLabel();
        this.raceSeriesNameLabel.setText("Race Series");
        FramerFactory.current.installComponent(this.raceSeriesNameLabel, this, 1, 136, 0.0f, 0.0f, 1230.0f, 315.0f);
        this.workingSetsComboBox = new JComboBox();
        this.workingSetsComboBox.setRenderer(new ConfigurableListCellRenderer(WORKING_SET_RENDERER));
        FramerFactory.current.installComponent(this.workingSetsComboBox, this, 1, 168, 1320.0f, 0.0f, 1035.0f, 315.0f);
        this.newWorkingSetButton = new JButton();
        this.newWorkingSetButton.setText("New...");
        this.newWorkingSetButton.setToolTipText("Create a new race series");
        this.newWorkingSetButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.newWorkingSetButton, this, 1, 40, 825.0f, 0.0f, 0.0f, 315.0f);
    }

    @Override
    protected void initWorkingSetDirectoryItems() {
        this.workingSetDirectoryLabel = new JLabel();
        this.workingSetDirectoryLabel.setText("Stored in");
        FramerFactory.current.installComponent(this.workingSetDirectoryLabel, this, 1, 136, 0.0f, 375.0f, 885.0f, 315.0f);
        this.workingSetDirectoryNameField = new JTextField();
        this.workingSetDirectoryNameField.setColumns(10);
        SwingServices.current.applyReadOnlyLookAndFeel(this.workingSetDirectoryNameField);
        FramerFactory.current.installComponent(this.workingSetDirectoryNameField, this, 1, 168, 1320.0f, 375.0f, 1035.0f, 315.0f);
        this.editConfigSettingsButton = new JButton();
        this.editConfigSettingsButton.setText("Settings");
        this.editConfigSettingsButton.setToolTipText("Edit the configuration settings");
        this.editConfigSettingsButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.editConfigSettingsButton, this, 1, 40, 825.0f, 375.0f, 0.0f, 315.0f);
    }

    protected DefaultComboBoxModel<WorkingSetSettings> constructWorkingSetsHolder() {
        return this.myApp().getToolUIModelServices().constructComboBoxListHolder(this.workingSets);
    }

    @Override
    protected void configureItems() {
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.workingSets = this.mySessionManager().getAvailableWorkingSets();
            Collections.sort(this.workingSets, new Comparator<WorkingSetSettings>(){

                @Override
                public int compare(WorkingSetSettings wss1, WorkingSetSettings wss2) {
                    return wss1.getDescription().compareTo(wss2.getDescription());
                }
            });
        } else {
            this.workingSets = new ArrayList<WorkingSetSettings>();
            this.workingSets.add(WorkingSetSettings.getCurrent());
        }
        this.workingSetsHolder = this.constructWorkingSetsHolder();
        this.workingSetsComboBox.setModel(this.workingSetsHolder);
        super.configureItems();
    }

    @Override
    protected void configureConnections() {
        final ApplicationView myView = (ApplicationView)((Object)this.getMainWindow());
        super.configureConnections();
        if (this.myApp().supportsWorkingSetSwitching()) {
            this.workingSetsComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    if (event.getStateChange() == 1) {
                        RaceSeriesDefinitionPanel.this.changeWorkingSet((WorkingSetSettings)event.getItem());
                    }
                }
            });
            this.newWorkingSetButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    RaceSeriesDefinitionPanel.this.myToolServices().newWorkingSet(myView);
                }
            });
        } else {
            this.newWorkingSetButton.setEnabled(false);
        }
        this.editConfigSettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RaceSeriesDefinitionPanel.this.myToolServices().editConfigurationSettings(myView);
            }
        });
    }

    @Override
    protected void setWorkingSetDescriptionItems() {
        this.selectCurrentWorkingSet();
        this.workingSetDirectoryNameField.setText(this.mySessionManager().getWorkingSetDirectory().getAbsolutePath());
    }

    protected void selectCurrentWorkingSet() {
        WorkingSetSettings wsSettings = WorkingSetSettings.getCurrent();
        if (this.workingSetsHolder.getIndexOf(wsSettings) == -1) {
            this.workingSetsHolder.insertElementAt(wsSettings, 0);
        }
        this.workingSetsHolder.setSelectedItem(wsSettings);
    }

    protected void changeWorkingSet(WorkingSetSettings selectedWorkingSet) {
        WorkingSetSettings currentWorkingSet = WorkingSetSettings.getCurrent();
        if (selectedWorkingSet.getDescription().equals(currentWorkingSet.getDescription())) {
            return;
        }
        this.myToolServices().openWorkingSet(selectedWorkingSet.getDirectory(), (ApplicationView)((Object)this.getMainWindow()));
    }
}

