/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.devx.DebugSupport;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.util.StatusValue;
import com.glaivestone.mv.ValueChangeEvent;
import com.glaivestone.mv.ValueChangeListener;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.RacerListEditor;
import org.ussamasters.aces.tools.ui.RacerListImportTool;
import org.ussamasters.aces.tools.ui.swing.RSTFrameWindow;
import org.ussamasters.aces.tools.ui.swing.TimingDataImportPanel;

public class RacerListImportToolWindow
extends RSTFrameWindow {
    public static final float DEFAULT_WIDTH_TWIPS = 11490.0f;
    public static final float DEFAULT_HEIGHT_TWIPS = 6525.0f;
    protected JCheckBox processNonStartersCheckBox;
    protected JButton importDataButton;
    protected TimingDataImportPanel timingDataImportPanel;

    @Override
    protected void initMainWindow() {
        super.initMainWindow();
        this.frameWindow.setTitle("Racer List Import Tool");
        this.setDefaultWindowSize();
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    @Override
    public void initChildComponents() {
        this.initTimingDataImportPanel();
        this.initProcessNonStartersCheckBox();
        this.initImportDataButton();
    }

    protected void initTimingDataImportPanel() {
        this.timingDataImportPanel = new TimingDataImportPanel();
        this.timingDataImportPanel.setName("timingDataImportPanel");
        FramerFactory.current.installComponent(this.timingDataImportPanel, this.contentPanel, 1, 170, 0.0f, 0.0f, 0.0f, 825.0f);
    }

    public void initProcessNonStartersCheckBox() {
        this.processNonStartersCheckBox = new JCheckBox();
        this.processNonStartersCheckBox.setName("processNonStartersCheckBox");
        this.processNonStartersCheckBox.setText("include DNS racers");
        FramerFactory.current.installComponent(this.processNonStartersCheckBox, this.contentPanel, 1, 130, 0.0f, 315.0f, 2040.0f, 465.0f);
    }

    public void initImportDataButton() {
        this.importDataButton = new JButton();
        this.importDataButton.setName("importDataButton");
        this.importDataButton.setText("Import...");
        this.importDataButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.importDataButton, this.contentPanel, 1, 66, 0.5f, 315.0f, 825.0f, 0.0f);
    }

    public void setDefaultWindowSize() {
        FramerFactory.current.setWindowSize(this, 1, 136, 1005.0f, 210.0f, 11490.0f, 6525.0f);
    }

    protected RacerListImportTool myApp() {
        return (RacerListImportTool)this.getAppModel();
    }

    @Override
    protected void initializeWindow() {
        this.configureAppNameWindowTitle();
        this.timingDataImportPanel.setModel(this.myApp().getTimingDataImportModel());
        this.importDataButton.setEnabled(false);
        this.configureConnections();
    }

    protected void configureConnections() {
        this.myApp().getTimingDataImportModel().getHasTimingDataHolder().addChangeListener(new ValueChangeListener(){

            @Override
            public void valueChanged(ValueChangeEvent event) {
                RacerListImportToolWindow.this.importDataButton.setEnabled(RacerListImportToolWindow.this.myApp().getTimingDataImportModel().getHasTimingDataHolder().getValue());
            }
        });
        this.importDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (RacerListImportToolWindow.this.importRacerList()) {
                    RacerListImportToolWindow.this.requestCloseWindow();
                }
            }
        });
    }

    protected boolean importRacerList() {
        StatusValue importStatus;
        ValidationResult validationResult = this.validateImportRequest();
        if (!validationResult.succeeded()) {
            MessageDialog.displayWarning("Import Racer Data Problem", validationResult.getMessage(), this.frameWindow);
            return false;
        }
        if (RacerListEditor.isOpen()) {
            boolean closeIt = MessageDialog.confirm("You cannot have the Racer List editor open while importing new racers. (Sorry, it's just a silly restriction that ought to get fixed at some point.)\n\nClose it now?", this.frameWindow);
            if (!closeIt) {
                return false;
            }
            if (!RacerListEditor.closeAllViews(RacerListEditor.TOOL_ID)) {
                return false;
            }
        }
        try {
            importStatus = this.myApp().importRacerListDataAndReconcile(this.processNonStartersCheckBox.isSelected());
        }
        catch (RaceDataIOException ex) {
            this.reportImportFailure(ex);
            return false;
        }
        catch (RuntimeException ex) {
            this.reportImportFailure(ex);
            return false;
        }
        if (!importStatus.succeeded()) {
            MessageDialog.displayMessage("Racer Import Failed", importStatus.getMessage(), this.frameWindow);
            return false;
        }
        return true;
    }

    protected void reportImportFailure(Exception ex) {
        if (ex instanceof RaceDataIOException) {
            this.timingDataImportPanel.selectLineContainingError((RaceDataIOException)ex);
        }
        DebugSupport.current().dump("****ERROR: " + ex.getLocalizedMessage());
        DebugSupport.current().dumpStack(ex, 10);
        MessageDialog.displayError("Racer Import Failed", ex.getLocalizedMessage(), this.frameWindow);
    }

    protected ValidationResult validateImportRequest() {
        ValidationResult validationResult = this.timingDataImportPanel.validateSpecifications();
        if (validationResult.failed()) {
            return validationResult;
        }
        return this.myApp().validateImportRequest();
    }

    public static void main(String[] args) {
        RacerListImportTool.initiateSession();
        RacerListImportTool appModel = new RacerListImportTool();
        appModel.openWindow(new RacerListImportToolWindow());
    }
}

