/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.tools.ui.RacerListTableHolder;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;

public class RacerListPanel
extends RSTPanel {
    protected RacerListTableHolder racerListHolder;
    protected JTable racerListTable;
    protected JScrollPane racerListScrollPane;
    protected JLabel sortByLabel;
    protected JPanel sortOrderButtonGroupPanel;
    protected ButtonGroup sortOrderButtonGroup;
    protected JRadioButton sortByNameRadioButton;
    protected JRadioButton sortByBibRadioButton;
    protected JRadioButton sortByAgeRadioButton;
    protected JRadioButton sortByClassRadioButton;
    protected JButton findButton;
    protected JTextField findArgItem;
    protected JLabel findArgInstructionsText;

    public RacerListPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("racerListPanel");
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected void initChildComponents() {
        this.initRacerListItems();
        this.initSortItems();
        this.initFindItems();
    }

    protected void initRacerListItems() {
        this.racerListScrollPane = new JScrollPane();
        FramerFactory.current.installComponent(this.racerListScrollPane, this, 1, 170, 0.0f, 0.0f, 0.0f, 960.0f);
        this.racerListTable = new JTable();
        this.racerListTable.setName("racerListTable");
        this.racerListScrollPane.setViewportView(this.racerListTable);
    }

    protected void initSortItems() {
        this.sortByLabel = new JLabel();
        this.sortByLabel.setName("sortByLabel");
        this.sortByLabel.setText("Sort by:");
        FramerFactory.current.installComponent(this.sortByLabel, this, 1, 130, 0.0f, 315.0f, 705.0f, 510.0f);
        this.sortOrderButtonGroupPanel = new JPanel();
        this.sortOrderButtonGroupPanel.setName("sortOrderButtonGroupPanel");
        FramerFactory.current.installComponent(this.sortOrderButtonGroupPanel, this, 1, 130, 915.0f, 480.0f, 3270.0f, 435.0f);
        this.sortOrderButtonGroupPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.sortOrderButtonGroup = new ButtonGroup();
        int LEFT_INSET_PROPOPTIONAL_TOP_FIXED_EXTENT = 132;
        this.sortByNameRadioButton = new JRadioButton();
        this.sortByNameRadioButton.setName("sortByNameRadioButton");
        this.sortByNameRadioButton.setText("name");
        FramerFactory.current.installComponent(this.sortByNameRadioButton, this.sortOrderButtonGroupPanel, 1, 132, 0.0f, 0.5f, 855.0f, 315.0f);
        this.sortOrderButtonGroup.add(this.sortByNameRadioButton);
        this.sortByBibRadioButton = new JRadioButton();
        this.sortByBibRadioButton.setName("sortByBibRadioButton");
        this.sortByBibRadioButton.setText("bib");
        FramerFactory.current.installComponent(this.sortByBibRadioButton, this.sortOrderButtonGroupPanel, 1, 132, 945.0f, 0.5f, 630.0f, 315.0f);
        this.sortOrderButtonGroup.add(this.sortByBibRadioButton);
        this.sortByAgeRadioButton = new JRadioButton();
        this.sortByAgeRadioButton.setName("sortByAgeRadioButton");
        this.sortByAgeRadioButton.setText("age");
        FramerFactory.current.installComponent(this.sortByAgeRadioButton, this.sortOrderButtonGroupPanel, 1, 132, 1650.0f, 0.5f, 690.0f, 315.0f);
        this.sortOrderButtonGroup.add(this.sortByAgeRadioButton);
        this.sortByClassRadioButton = new JRadioButton();
        this.sortByClassRadioButton.setName("sortByClassRadioButton");
        this.sortByClassRadioButton.setText("class");
        FramerFactory.current.installComponent(this.sortByClassRadioButton, this.sortOrderButtonGroupPanel, 1, 132, 2400.0f, 0.5f, 825.0f, 315.0f);
        this.sortOrderButtonGroup.add(this.sortByClassRadioButton);
    }

    protected void initFindItems() {
        this.findButton = new JButton();
        this.findButton.setMargin(new Insets(0, 0, 0, 0));
        this.findButton.setName("findButton");
        this.findButton.setText("Find");
        FramerFactory.current.installComponent(this.findButton, this, 1, 130, 0.0f, 315.0f, 825.0f, 0.0f);
        this.findArgItem = new JTextField();
        this.findArgItem.setName("findArgItem");
        this.findArgItem.setColumns(10);
        FramerFactory.current.installComponent(this.findArgItem, this, 1, 162, 915.0f, 315.0f, 1410.0f, 0.0f);
        this.findArgInstructionsText = new JLabel();
        this.findArgInstructionsText.setName("findArgInstructionsText");
        this.findArgInstructionsText.setText("(bib or name)");
        FramerFactory.current.installComponent(this.findArgInstructionsText, this, 1, 34, 1260.0f, 315.0f, 0.0f, 0.0f);
    }

    protected void initializeWindow() {
        this.racerListTable.setModel(this.racerListHolder.getDataModel());
        this.racerListTable.setSelectionModel(this.racerListHolder.getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.racerListTable);
        int sortOrder = this.racerListHolder.getSortOrder();
        switch (sortOrder) {
            case 0: {
                this.sortByNameRadioButton.setSelected(true);
                break;
            }
            case 1: {
                this.sortByBibRadioButton.setSelected(true);
                break;
            }
            case 2: {
                this.sortByAgeRadioButton.setSelected(true);
                break;
            }
            case 3: {
                this.sortByClassRadioButton.setSelected(true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown racer list sort order: " + sortOrder);
            }
        }
        this.configureConnections();
    }

    protected void configureConnections() {
        this.configureSortOrderHandler(this.sortByNameRadioButton, 0);
        this.configureSortOrderHandler(this.sortByBibRadioButton, 1);
        this.configureSortOrderHandler(this.sortByAgeRadioButton, 2);
        this.configureSortOrderHandler(this.sortByClassRadioButton, 3);
        this.findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                RacerListPanel.this.findRacer();
            }
        });
        this.findArgItem.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                if (event.getKeyChar() == '\n') {
                    RacerListPanel.this.findRacer();
                    RacerListPanel.this.findArgItem.requestFocus();
                }
            }
        });
    }

    protected void configureSortOrderHandler(final JRadioButton aRadioButton, final int sortOrder) {
        aRadioButton.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (aRadioButton.isSelected()) {
                    RacerListPanel.this.racerListHolder.setSortOrder(sortOrder);
                    RacerListPanel.this.ensureSelectionIsVisible();
                }
            }
        });
    }

    public void setRacerListHolder(RacerListTableHolder racerListHolder) {
        this.racerListHolder = racerListHolder;
        this.initializeWindow();
    }

    public void ensureSelectionIsVisible() {
        this.myToolServices().scrollRowIntoView(this.racerListHolder.getSelectedIndex(), this.racerListTable);
    }

    public void registerListDoubleClickedHandler(EvaluableAction eventHandler) {
        this.myToolServices().registerDoubleClickHandler((JComponent)this.racerListTable, eventHandler);
    }

    public JTable getRacerListTablePane() {
        return this.racerListTable;
    }

    protected void findRacer() {
        String findArg = this.findArgItem.getText();
        if (findArg == null || (findArg = findArg.trim()).length() == 0) {
            MessageDialog.displayMessage("No Find Value Specified", "Please enter the bib number or the first few letters of the last name of the racer you want to find.", this);
            return;
        }
        this.findRacer(findArg);
    }

    public void registerListDoubleClickedHandler(ActionListener eventHandler) {
        this.myToolServices().registerDoubleClickHandler((JComponent)this.racerListTable, eventHandler);
    }

    public void registerListPopupMenu(JPopupMenu aPopupMenu) {
        this.myToolServices().registerPanePopupHandler(this.racerListTable, aPopupMenu);
    }

    protected void findRacer(String findArg) {
        Racer aRacer;
        String notFoundMessagePrefix;
        if (Character.isDigit(findArg.charAt(0))) {
            try {
                notFoundMessagePrefix = "No racer with bib number ";
                aRacer = this.racerListHolder.getRacerList().findBib(Integer.parseInt(findArg));
            }
            catch (NumberFormatException ex) {
                MessageDialog.displayWarning("Invalid Bib Number", "Please enter a racer bib number which is a positive integer value.", this);
                return;
            }
        } else {
            notFoundMessagePrefix = "No racer whose last name starts with ";
            aRacer = this.racerListHolder.getRacerList().findLastName(findArg, false);
        }
        if (aRacer == null) {
            MessageDialog.displayMessage("Not Found", notFoundMessagePrefix + findArg + " was found.", this);
            return;
        }
        int rowIndex = this.racerListHolder.indexOf(aRacer);
        if (rowIndex < 0) {
            return;
        }
        this.racerListHolder.selectIndex(rowIndex);
        this.myToolServices().scrollRowIntoView(rowIndex, this.racerListTable);
    }
}

