/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.javax.swing.MessageDialog;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.tools.foundation.processors.ValidationResult;
import org.ussamasters.aces.tools.ui.TimingDataImportModel;
import org.ussamasters.aces.tools.ui.swing.RSTPanel;

public class TimingDataImportPanel
extends RSTPanel {
    protected static final String RESOURCE_NAME_TIMING_DATA_FILE_CHOOSER = TimingDataImportPanel.class.getName() + ".TimingDataFileChooser";
    protected static JFileChooser startGroupsSpecFileChooser;
    protected static JFileChooser timingDataColumnsSpecFileChooser;
    protected JLabel timingDataFileNameLabel;
    protected JTextField timingDataFileNameField;
    protected JButton chooseTimingDataFileButton;
    protected JLabel timingDataLabel;
    protected JScrollPane timingDataTextAreaScrollPane;
    protected JTextArea timingDataTextArea;
    protected JPanel columnSpecsPanel;
    protected JLabel timingDataColumnsLabel;
    protected JScrollPane timingDataColumnsListScrollPane;
    protected JList<String> timingDataColumnsList;
    protected JButton chooseTimingDataColumnsSpecButton;
    protected JButton useTimingDataforColumnSpecsButton;
    protected JButton openTimingDataFormatsDocButton;
    protected JPanel startGroupCodesPanel;
    protected JCheckBox startGroupCodesCheckBox;
    protected JScrollPane startGroupCodesMapScrollPane;
    protected JTable startGroupCodesTablePane;
    protected JButton chooseStartGroupsSpecButton;
    protected TimingDataImportModel timingSourceModel;
    protected Highlighter startGroupCodeSpecsPaneHilighter;
    protected Runnable scrollToStartOfTimingDataAction;

    public TimingDataImportPanel() {
        this.init();
    }

    protected void init() {
        this.initSelf();
        this.initChildComponents();
    }

    protected void initSelf() {
        this.setName("timingDataImportPanel");
        this.setBorder(BorderFactory.createTitledBorder("Timing System Results Data"));
        this.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected void initChildComponents() {
        this.initTimingDataFileItems();
        this.initTimingDataItems();
        this.initTimingDataColumnsPanel();
        this.initStartGroupCodesPanel();
    }

    protected void initTimingDataFileItems() {
        this.timingDataFileNameLabel = new JLabel();
        this.timingDataFileNameLabel.setName("inputFileLabel");
        this.timingDataFileNameLabel.setText("Input File(s):");
        FramerFactory.current.installComponent(this.timingDataFileNameLabel, this, 1, 136, 0.0f, 0.0f, 1095.0f, 315.0f);
        this.timingDataFileNameField = new JTextField();
        this.timingDataFileNameField.setColumns(10);
        SwingServices.current.applyReadOnlyLookAndFeel(this.timingDataFileNameField);
        FramerFactory.current.installComponent(this.timingDataFileNameField, this, 1, 168, 1200.0f, 0.0f, 600.0f, 315.0f);
        this.chooseTimingDataFileButton = new JButton();
        this.chooseTimingDataFileButton.setName("chooseTimingDataFileButton");
        this.chooseTimingDataFileButton.setText("...");
        this.chooseTimingDataFileButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.chooseTimingDataFileButton, this, 1, 40, 468.0f, 0.0f, 0.0f, 315.0f);
    }

    protected void initTimingDataItems() {
        this.timingDataLabel = new JLabel();
        this.timingDataLabel.setName("timingDataLabel");
        this.timingDataLabel.setText("Timing Data:");
        FramerFactory.current.installComponent(this.timingDataLabel, this, 1, 136, 0.0f, 420.0f, 1116.0f, 315.0f);
        this.timingDataTextAreaScrollPane = new JScrollPane();
        FramerFactory.current.installComponent(this.timingDataTextAreaScrollPane, this, 1, 170, 0.0f, 780.0f, 0.0f, 1785.0f);
        this.timingDataTextArea = new JTextArea();
        this.timingDataTextArea.setName("timingDataTextArea");
        this.timingDataTextArea.setLineWrap(true);
        this.timingDataTextArea.setWrapStyleWord(true);
        this.timingDataTextArea.setRows(6);
        this.timingDataTextArea.setColumns(16);
        this.timingDataTextAreaScrollPane.setViewportView(this.timingDataTextArea);
    }

    protected void initTimingDataColumnsPanel() {
        this.columnSpecsPanel = new JPanel();
        this.columnSpecsPanel.setName("columnSpecsPanel");
        FramerFactory.current.installComponent(this.columnSpecsPanel, this, 1, 178, 0.0f, 1605.0f, 0.5f, 0.0f);
        this.columnSpecsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.timingDataColumnsLabel = new JLabel();
        this.timingDataColumnsLabel.setName("timingDataColumnsLabel");
        this.timingDataColumnsLabel.setText("Timing Data Column Order:");
        FramerFactory.current.installComponent(this.timingDataColumnsLabel, this.columnSpecsPanel, 1, 136, 0.0f, 0.0f, 2415.0f, 315.0f);
        this.timingDataColumnsListScrollPane = new JScrollPane();
        FramerFactory.current.installComponent(this.timingDataColumnsListScrollPane, this.columnSpecsPanel, 1, 170, 0.0f, 360.0f, 630.0f, 0.0f);
        this.timingDataColumnsList = new JList();
        this.timingDataColumnsList.setName("timingDataColumnsList");
        this.timingDataColumnsList.setVisibleRowCount(6);
        this.timingDataColumnsListScrollPane.setViewportView(this.timingDataColumnsList);
        this.chooseTimingDataColumnsSpecButton = new JButton();
        this.chooseTimingDataColumnsSpecButton.setName("chooseTimingDataColumnsSpecButton");
        this.chooseTimingDataColumnsSpecButton.setText("...");
        this.chooseTimingDataColumnsSpecButton.setToolTipText("Load column order specifications from spec file");
        this.chooseTimingDataColumnsSpecButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.chooseTimingDataColumnsSpecButton, this.columnSpecsPanel, 1, 40, 468.0f, 324.0f, 108.0f, 315.0f);
        this.useTimingDataforColumnSpecsButton = new JButton();
        this.useTimingDataforColumnSpecsButton.setName("useTimingDataforColumnSpecsButton");
        this.useTimingDataforColumnSpecsButton.setText("Ln 1");
        this.useTimingDataforColumnSpecsButton.setToolTipText("Load column order specifications from first line of timing data");
        this.useTimingDataforColumnSpecsButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.useTimingDataforColumnSpecsButton, this.columnSpecsPanel, 1, 40, 468.0f, 650.0f, 108.0f, 315.0f);
        this.openTimingDataFormatsDocButton = new JButton();
        this.openTimingDataFormatsDocButton.setName("openTimingDataFormatsDocButton");
        this.openTimingDataFormatsDocButton.setText("??");
        this.openTimingDataFormatsDocButton.setToolTipText("Open documentation on timing data formats");
        this.openTimingDataFormatsDocButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.openTimingDataFormatsDocButton, this.columnSpecsPanel, 1, 40, 468.0f, 990.0f, 108.0f, 315.0f);
    }

    public void initStartGroupCodesPanel() {
        this.startGroupCodesPanel = new JPanel();
        this.startGroupCodesPanel.setName("startGroupCodesPanel");
        FramerFactory.current.installComponent(this.startGroupCodesPanel, this, 1, 98, 0.504f, 1605.0f, 0.0f, 0.0f);
        this.startGroupCodesPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.startGroupCodesCheckBox = new JCheckBox();
        this.startGroupCodesCheckBox.setName("startGroupCodesCheckBox");
        this.startGroupCodesCheckBox.setText("Start Group Codes:");
        FramerFactory.current.installComponent(this.startGroupCodesCheckBox, this.startGroupCodesPanel, 1, 136, 0.0f, 0.0f, 2160.0f, 315.0f);
        this.startGroupCodesMapScrollPane = new JScrollPane();
        this.startGroupCodesMapScrollPane.setName("startGroupCodesMapScrollPane");
        FramerFactory.current.installComponent(this.startGroupCodesMapScrollPane, this.startGroupCodesPanel, 1, 170, 0.0f, 360.0f, 630.0f, 0.0f);
        this.startGroupCodesTablePane = new JTable();
        this.startGroupCodesTablePane.setName("startGroupCodesTablePane");
        this.startGroupCodesMapScrollPane.setViewportView(this.startGroupCodesTablePane);
        this.chooseStartGroupsSpecButton = new JButton();
        this.chooseStartGroupsSpecButton.setName("chooseStartGroupsSpecButton");
        this.chooseStartGroupsSpecButton.setText("...");
        this.chooseStartGroupsSpecButton.setMargin(new Insets(0, 0, 0, 0));
        FramerFactory.current.installComponent(this.chooseStartGroupsSpecButton, this.startGroupCodesPanel, 1, 40, 468.0f, 315.0f, 0.0f, 315.0f);
    }

    protected TimingDataImportModel myApp() {
        return this.timingSourceModel;
    }

    protected void setModel(TimingDataImportModel timingSourceModel) {
        this.timingSourceModel = timingSourceModel;
        this.initializeWindow();
    }

    protected void initializeWindow() {
        this.timingDataFileNameField.setDocument(this.myApp().getTimingDataFileNamesModel());
        this.timingDataTextArea.setDocument(this.myApp().getTimingDataModel());
        this.timingDataColumnsList.setModel(this.myApp().getTimingDataColumnsModel().getDataModel());
        this.startGroupCodesTablePane.setModel(this.myApp().getStartGroupCodesMapHolder().getDataModel());
        this.startGroupCodesTablePane.setSelectionModel(this.myApp().getStartGroupCodesMapHolder().getSelectionModel());
        this.myToolServices().installNoDirectEditLAF(this.startGroupCodesTablePane);
        this.updateTimingDataColumnItems();
        this.updateStartGroupItems();
        this.updateStartGroupCodesItems(this.startGroupCodesCheckBox.isSelected());
        this.scrollToStartOfTimingDataAction = new Runnable(){

            @Override
            public void run() {
                TimingDataImportPanel.this.scrollToStartOfTimingData();
            }
        };
        this.configureConnections();
    }

    protected void configureConnections() {
        boolean DEBUG_TIMING_DATA_CLICK = false;
        if (DEBUG_TIMING_DATA_CLICK) {
            System.out.println("***CONFIGURING BUTTON HANDLER TO CHOOSE TIMING DATA FILE***");
        }
        this.chooseTimingDataFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                boolean DEBUG_TIMING_DATA_CLICK = false;
                if (DEBUG_TIMING_DATA_CLICK) {
                    System.out.println("*****Choose-timing-data button clicked*****");
                }
                TimingDataImportPanel.this.chooseTimingDataFile();
            }
        });
        this.chooseTimingDataColumnsSpecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimingDataImportPanel.this.chooseTimingDataColumnsSpecFile();
            }
        });
        this.useTimingDataforColumnSpecsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimingDataImportPanel.this.installTimingDataColumnsSpec();
            }
        });
        this.openTimingDataFormatsDocButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimingDataImportPanel.this.myToolServices().openTimingDataFormatsDoc((ApplicationView)((Object)TimingDataImportPanel.this.getMainWindow()));
            }
        });
        this.myApp().getTimingDataColumnsModel().getDataModel().addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent event) {
                TimingDataImportPanel.this.updateStartGroupItems();
            }

            @Override
            public void intervalAdded(ListDataEvent event) {
                TimingDataImportPanel.this.updateStartGroupItems();
            }

            @Override
            public void intervalRemoved(ListDataEvent event) {
            }
        });
        this.startGroupCodesCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                boolean isNowSelected = TimingDataImportPanel.this.startGroupCodesCheckBox.isSelected();
                boolean isRequired = TimingDataImportPanel.this.myApp().isStartGroupCodesMapRequired();
                if (isRequired && !isNowSelected) {
                    TimingDataImportPanel.this.startGroupCodesCheckBox.setSelected(true);
                    MessageDialog.displayWarning("Required Load Option", "You cannot turn off a required load option setting.\n\nYou must specify the mapping from start group code to age class that will be used to interpret a StartGroupCode value when loading the timing data.", TimingDataImportPanel.this.getMainWindow());
                }
                TimingDataImportPanel.this.enableStartGroupCodeSpecification(isNowSelected);
            }
        });
        this.chooseStartGroupsSpecButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TimingDataImportPanel.this.chooseStartGroupsSpecFile();
            }
        });
    }

    protected void chooseStartGroupsSpecFile() {
        JFileChooser fd = this.getStartGroupsSpecFileChooser();
        int option = fd.showOpenDialog(this.getMainWindow());
        if (option != 0) {
            return;
        }
        File selectedFile = fd.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        try {
            this.myApp().loadStartGroupSpecs(selectedFile);
        }
        catch (RaceDataIOException ex) {
            MessageDialog.displayError("Unable to Load Start Group Specifications", ex.getMessage(), this.getMainWindow());
        }
        this.myToolServices().installNoDirectEditLAF(this.startGroupCodesTablePane);
    }

    protected void chooseTimingDataColumnsSpecFile() {
        JFileChooser fd = this.getTimingDataColumnsSpecFileChooser();
        int option = fd.showOpenDialog(this.getMainWindow());
        if (option != 0) {
            return;
        }
        File selectedFile = fd.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        this.installTimingDataColumnsSpec(selectedFile);
    }

    protected void chooseTimingDataFile() {
        String message;
        JFileChooser fd = this.getTimingDataFileChooser();
        int option = fd.showOpenDialog(this.getMainWindow());
        if (option != 0) {
            return;
        }
        File[] selectedFiles = fd.getSelectedFiles();
        if (selectedFiles.length == 0) {
            return;
        }
        try {
            this.myApp().loadTimingData(selectedFiles);
        }
        catch (IOException ex) {
            MessageDialog.displayMessage("Timing Data Load Failed", "Unable to load the selected timing system data: " + ex.getMessage(), this.getMainWindow());
        }
        this.scrollToStartOfTimingData();
        this.updateTimingDataColumnItems();
        this.updateStartGroupItems();
        File defaultColumnSpecFile = this.myApp().defaultColumnSpecFile(fd.getCurrentDirectory());
        if (defaultColumnSpecFile != null && MessageDialog.confirm(message = "Set column order to the standard field order for this data source?\n\n(user configuration file " + defaultColumnSpecFile.getParentFile().getName() + File.separator + defaultColumnSpecFile.getName() + ")", this.getMainWindow())) {
            this.installTimingDataColumnsSpec(defaultColumnSpecFile);
        }
    }

    protected void enableStartGroupCodeSpecification(boolean enableStartGroupCodeItems) {
        this.myApp().updateStartGroupSpecs(enableStartGroupCodeItems);
        this.updateStartGroupCodesItems(enableStartGroupCodeItems);
    }

    protected int findLine(String targetLine) {
        String timingData = this.myApp().getTimingDataModel().getText();
        LineNumberReader reader = new LineNumberReader(new StringReader(timingData));
        try {
            String aLine;
            while ((aLine = reader.readLine()) != null) {
                if (!aLine.equals(targetLine)) continue;
                return reader.getLineNumber() - 1;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    protected JFileChooser getStartGroupsSpecFileChooser() {
        if (startGroupsSpecFileChooser == null) {
            File specFile = this.myApp().defaultStartGroupSpecsFile();
            JFileChooser fd = new JFileChooser();
            if (specFile.exists()) {
                fd.setSelectedFile(specFile);
            } else {
                fd.setCurrentDirectory(this.myApp().defaultStartGroupSpecsDirectory());
            }
            startGroupsSpecFileChooser = fd;
        }
        return startGroupsSpecFileChooser;
    }

    protected JFileChooser getTimingDataColumnsSpecFileChooser() {
        if (timingDataColumnsSpecFileChooser == null) {
            JFileChooser fd = new JFileChooser();
            fd.setCurrentDirectory(this.myApp().defaultColumnSpecsDirectory());
            timingDataColumnsSpecFileChooser = fd;
        }
        return timingDataColumnsSpecFileChooser;
    }

    protected JFileChooser getTimingDataFileChooser() {
        JFileChooser timingDataFileChooser = (JFileChooser)this.mySessionManager().getWorkingSetResource(RESOURCE_NAME_TIMING_DATA_FILE_CHOOSER);
        if (timingDataFileChooser == null) {
            JFileChooser fd = new JFileChooser();
            fd.setMultiSelectionEnabled(true);
            fd.setCurrentDirectory(this.myApp().defaultTimingDataFileDirectory());
            this.mySessionManager().registerWorkingSetResource(RESOURCE_NAME_TIMING_DATA_FILE_CHOOSER, fd);
            timingDataFileChooser = fd;
        }
        if (!timingDataFileChooser.getCurrentDirectory().exists()) {
            timingDataFileChooser.setCurrentDirectory(this.myApp().defaultTimingDataFileDirectory());
        }
        return timingDataFileChooser;
    }

    protected void installTimingDataColumnsSpec() {
        try {
            this.myApp().loadColumnSpecs();
        }
        catch (IOException ex) {
            MessageDialog.displayMessage("Column Specs Load Failed", "Unable to load column specifications from the timing data: " + ex.getMessage(), this.getMainWindow());
        }
    }

    protected void installTimingDataColumnsSpec(File columnSpecFile) {
        try {
            this.myApp().loadColumnSpecs(columnSpecFile);
        }
        catch (IOException ex) {
            MessageDialog.displayMessage("Column Specs Load Failed", "Unable to load the column specifications file: " + ex.getMessage(), this.getMainWindow());
        }
    }

    protected void scrollLineIntoView(int lineNumber, JTextArea textPane, JScrollPane textPaneScroller) {
        int lineStartOffset;
        try {
            lineStartOffset = textPane.getLineStartOffset(lineNumber);
        }
        catch (BadLocationException ex) {
            return;
        }
        SwingServices.current.scrollTextIntoView(lineStartOffset, textPaneScroller, 1, 6);
    }

    protected void scrollToStartOfTimingData() {
        this.timingDataTextArea.requestFocus();
        this.timingDataTextArea.select(0, 0);
        this.scrollLineIntoView(0, this.timingDataTextArea, this.timingDataTextAreaScrollPane);
    }

    public void selectLineContainingError(RaceDataIOException ex) {
        if (ex.getData() == null || !(ex.getData() instanceof String)) {
            return;
        }
        String errorLine = (String)ex.getData();
        int lineNumber = this.findLine(errorLine);
        if (lineNumber == -1) {
            return;
        }
        try {
            int lineStartOffset = this.timingDataTextArea.getLineStartOffset(lineNumber);
            this.timingDataTextArea.requestFocus();
            this.timingDataTextArea.select(lineStartOffset, lineStartOffset + errorLine.length() + 1);
        }
        catch (BadLocationException ex2) {
            return;
        }
        this.scrollLineIntoView(lineNumber, this.timingDataTextArea, this.timingDataTextAreaScrollPane);
    }

    protected void updateStartGroupItems() {
        boolean enableStartGroupCodeItems = this.myApp().isStartGroupCodesMapAllowed();
        this.startGroupCodesCheckBox.setSelected(enableStartGroupCodeItems && this.myApp().isStartGroupCodesMapExpected());
        this.startGroupCodesCheckBox.setEnabled(enableStartGroupCodeItems);
    }

    protected void updateStartGroupCodesItems(boolean enableStartGroupCodeItems) {
        this.startGroupCodesTablePane.setEnabled(enableStartGroupCodeItems);
        this.chooseStartGroupsSpecButton.setEnabled(enableStartGroupCodeItems);
    }

    protected void updateTimingDataColumnItems() {
        boolean enableTimingDataColumnItems = this.myApp().getTimingDataColumnsModel().size() > 0;
        boolean enableTimingDataColumnChange = this.myApp().isTimingDataColumnSpecAllowed();
        this.timingDataColumnsLabel.setEnabled(enableTimingDataColumnItems);
        this.timingDataColumnsList.setEnabled(enableTimingDataColumnItems);
        this.chooseTimingDataColumnsSpecButton.setEnabled(enableTimingDataColumnChange);
        this.useTimingDataforColumnSpecsButton.setEnabled(enableTimingDataColumnChange);
    }

    protected ValidationResult validateSpecifications() {
        if (this.startGroupCodesCheckBox.isSelected() && !this.myApp().isStartGroupCodesMapDefined()) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.reportProblem("You must specify how to map start group codes to age classes in order to interpret values in the timing data StartGroupCode field.");
            return validationResult;
        }
        return ValidationResult.SUCCESS_RESULT;
    }
}

