/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.tools.ui.swing;

import com.glaivestone.toolbox.partsframer.FramerFactory;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.ussamasters.aces.racedata.models.CourseArrangement;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.StandingsType;
import org.ussamasters.aces.tools.ui.swing.OKCancelButtonsPanel;
import org.ussamasters.aces.tools.ui.swing.RSTDialogWindow;

public abstract class WorkingSetSettingsEditorWindow
extends RSTDialogWindow {
    protected static float RACE_SERIES_ID_PANEL_HEIGHT_TWIPS = 830.0f;
    protected static final float RACE_SERIES_SETTINGS_PANEL_HEIGHT_TWIPS = 2940.0f;
    protected JLabel raceSeriesNameLabel;
    protected JTextField raceSeriesNameField;
    protected JLabel workingSetDirectoryLabel;
    protected JTextField workingSetDirectoryNameField;
    protected JLabel seriesTypeLabel;
    protected JComboBox<StandingsType> seriesTypeComboBox;
    protected JLabel organizerLabel;
    protected JComboBox<RaceOrganization> organizerComboBox;
    protected JLabel seasonYearLabel;
    protected JTextField seasonYearField;
    protected JLabel courseArrangementLabel;
    protected JComboBox<CourseArrangement> courseArrangementComboBox;
    protected JLabel raceClassesLabel;
    protected JComboBox<RaceClassType> raceClassesComboBox;
    protected JLabel worldCupPointsLabel;
    protected JComboBox<RaceClassType> worldCupPointsComboBox;
    protected OKCancelButtonsPanel operationButtonsPanel;
    protected Map<String, Object> propertyValueItemMap;

    public WorkingSetSettingsEditorWindow() {
    }

    public WorkingSetSettingsEditorWindow(Dialog owner) {
        super(owner);
    }

    public WorkingSetSettingsEditorWindow(Frame owner) {
        super(owner);
    }

    @Override
    protected void initContentPanel() {
        super.initContentPanel();
        this.contentPanel.setLayout(FramerFactory.current.newLayoutManager());
    }

    protected abstract float initRacerSeriesNameItems(JPanel var1, float var2, float var3);

    protected abstract float initRaceSeriesDirectoryItems(JPanel var1, float var2, float var3);

    protected JPanel initRaceSeriesIdentificationPanel(float leftOffsetValueCol) {
        float itemTopOffset = 0.0f;
        JPanel raceSeriesIdPanel = new JPanel();
        FramerFactory.current.installComponent(raceSeriesIdPanel, this.contentPanel, 1, 168, 0.0f, 0.0f, 0.0f, RACE_SERIES_ID_PANEL_HEIGHT_TWIPS);
        raceSeriesIdPanel.setLayout(FramerFactory.current.newLayoutManager());
        float dyLine = this.initRacerSeriesNameItems(raceSeriesIdPanel, itemTopOffset, leftOffsetValueCol);
        this.raceSeriesNameField.setToolTipText("Descriptive name of the race series");
        itemTopOffset += dyLine;
        dyLine = this.initRaceSeriesDirectoryItems(raceSeriesIdPanel, itemTopOffset, leftOffsetValueCol);
        this.workingSetDirectoryNameField.setToolTipText("Directory in which the race series scoring data is stored");
        return raceSeriesIdPanel;
    }

    protected JPanel initRaceSeriesSettingsPanel(float leftOffset, float topOffset, float leftOffsetValueCol) {
        float itemTopOffset = 0.0f;
        JPanel raceSeriesSettingsPanel = new JPanel();
        raceSeriesSettingsPanel.setBorder(BorderFactory.createTitledBorder("Race Series Settings"));
        FramerFactory.current.installComponent(raceSeriesSettingsPanel, this.contentPanel, 1, 168, leftOffset, topOffset, 0.0f, 2940.0f);
        raceSeriesSettingsPanel.setLayout(FramerFactory.current.newLayoutManager());
        this.organizerLabel = new JLabel();
        this.organizerLabel.setText("Organizer");
        FramerFactory.current.installComponent(this.organizerLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, 0.0f, 945.0f, 315.0f);
        this.organizerComboBox = new JComboBox();
        this.organizerComboBox.setToolTipText("Organization which runs this race series");
        FramerFactory.current.installComponent(this.organizerComboBox, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, 0.0f, 2760.0f, 345.0f);
        this.seriesTypeLabel = new JLabel();
        this.seriesTypeLabel.setText("Series type");
        FramerFactory.current.installComponent(this.seriesTypeLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, itemTopOffset += 445.0f, 1020.0f, 315.0f);
        this.seriesTypeComboBox = new JComboBox();
        this.myToolServices().installConstantNameRenderer(this.seriesTypeComboBox);
        this.seriesTypeComboBox.setToolTipText("Standard race series or season scoring series");
        FramerFactory.current.installComponent(this.seriesTypeComboBox, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 2760.0f, 345.0f);
        this.seasonYearLabel = new JLabel();
        this.seasonYearLabel.setText("Season");
        FramerFactory.current.installComponent(this.seasonYearLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, itemTopOffset += 445.0f, 990.0f, 315.0f);
        this.seasonYearField = new JTextField();
        this.seasonYearField.setColumns(10);
        this.seasonYearField.setToolTipText("Season in which this race series occurred (end year)");
        FramerFactory.current.installComponent(this.seasonYearField, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 3600.0f, 315.0f);
        this.raceClassesLabel = new JLabel();
        this.raceClassesLabel.setText("Classes");
        FramerFactory.current.installComponent(this.raceClassesLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, itemTopOffset += 415.0f, 855.0f, 315.0f);
        this.raceClassesComboBox = new JComboBox();
        this.myToolServices().installRaceClassTypeRenderer(this.raceClassesComboBox);
        this.raceClassesComboBox.setToolTipText("Age class groups ordinarily used for races in this series");
        FramerFactory.current.installComponent(this.raceClassesComboBox, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 1185.0f, 345.0f);
        this.worldCupPointsLabel = new JLabel();
        this.worldCupPointsLabel.setText("Scoring");
        FramerFactory.current.installComponent(this.worldCupPointsLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, itemTopOffset += 445.0f, 1020.0f, 315.0f);
        this.worldCupPointsComboBox = new JComboBox();
        this.myToolServices().installWorldCupPointsRenderer(this.worldCupPointsComboBox);
        this.worldCupPointsComboBox.setToolTipText("World Cup points scoring for this series");
        FramerFactory.current.installComponent(this.worldCupPointsComboBox, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 1185.0f, 345.0f);
        this.courseArrangementLabel = new JLabel();
        this.courseArrangementLabel.setText("Courses");
        FramerFactory.current.installComponent(this.courseArrangementLabel, raceSeriesSettingsPanel, 1, 136, 0.0f, itemTopOffset += 415.0f, 870.0f, 315.0f);
        this.courseArrangementComboBox = new JComboBox();
        this.myToolServices().installConstantNameRenderer(this.courseArrangementComboBox);
        this.courseArrangementComboBox.setToolTipText("Arrangement of courses ordinarily used for races in this series");
        FramerFactory.current.installComponent(this.courseArrangementComboBox, raceSeriesSettingsPanel, 1, 168, leftOffsetValueCol, itemTopOffset, 1020.0f, 345.0f);
        return raceSeriesSettingsPanel;
    }

    protected void initOperationButtonsPanel() {
        this.operationButtonsPanel = new OKCancelButtonsPanel();
        this.operationButtonsPanel.setName("operationButtonsPanel");
        FramerFactory.current.installComponent(this.operationButtonsPanel, this.contentPanel, this.operationButtonsPanel.bottomCenterFramingSpec());
    }

    protected Map<String, Object> constructPropertyValueItemMap() {
        HashMap<String, Object> mappingTable = new HashMap<String, Object>();
        this.registerPropertyValueItems(mappingTable);
        return mappingTable;
    }

    protected void registerPropertyValueItems(Map<String, Object> mappingTable) {
    }

    protected void configureOperationButtonConnections() {
        this.operationButtonsPanel.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (WorkingSetSettingsEditorWindow.this.acceptChanges()) {
                    WorkingSetSettingsEditorWindow.this.requestCloseWindow();
                }
            }
        });
        this.operationButtonsPanel.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WorkingSetSettingsEditorWindow.this.requestCloseWindow();
            }
        });
    }

    protected abstract boolean acceptChanges();
}

