/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.javax.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.ussamasters.javax.io.ConstantSpecifications;
import org.ussamasters.javax.io.ResourceFileAccessor;
import org.yaml.snakeyaml.Yaml;

public class ConstantLoader
extends ResourceFileAccessor {
    public static final List<String> SUPPORTED_KEYS = Collections.unmodifiableList(Arrays.asList("type", "fields", "values", "synonyms"));
    protected Yaml yaml = new Yaml();

    public static ConstantSpecifications loadSpecificationsFromFile(String fileRef) {
        ConstantLoader loader = new ConstantLoader();
        ConstantSpecifications specs = loader.loadFromFile(fileRef);
        return specs;
    }

    public static void checkSpecificationLoading(String fileRef) {
        String SEP = "----------------------------\n";
        System.out.println("TEST CONSTANT SPECIFICATIONS YAML LOADING");
        System.out.println(SEP + fileRef);
        ConstantLoader loader = new ConstantLoader();
        ConstantSpecifications specs = loader.loadFromFile(fileRef);
        System.out.println("" + specs + "\n" + SEP);
        System.out.println(loader.describeSpecs(specs));
        System.out.println(SEP);
    }

    public ConstantSpecifications loadFromFile(String fileRef) {
        String yamlText = this.readFileToString(fileRef);
        return this.loadFromYaml(yamlText);
    }

    public ConstantSpecifications loadFromYaml(String yamlText) {
        ConstantSpecifications specs = null;
        specs = (ConstantSpecifications)this.yaml.loadAs(yamlText, ConstantSpecifications.class);
        return specs;
    }

    public String describeSpecs(ConstantSpecifications specs) {
        Map<String, List<String>> synonyms = specs.getSynonymsMap();
        ArrayList<String> synonymNames = new ArrayList<String>();
        if (specs.hasSynonyms()) {
            for (String key : synonyms.keySet()) {
                synonymNames.add(key);
            }
            Collections.sort(synonymNames);
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(String.format("Constant definitions: %s", specs.getConstantType()));
        lines.add(String.format("fields: %s", specs.getFields()));
        if (specs.hasOptionalFields()) {
            lines.add(String.format("optionalFields: %s", specs.getOptionalFields()));
        }
        lines.add("values:");
        for (Object unprocessedEntry : specs.getValues()) {
            lines.add("  - " + unprocessedEntry);
        }
        if (specs.hasSynonyms()) {
            lines.add("synonyms:");
            for (String name : synonymNames) {
                List<String> altNames = synonyms.get(name);
                lines.add(String.format("  %s: %s", name, altNames));
            }
        }
        return StringUtils.join(lines, "\n");
    }
}

