/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.awt.print;

import com.glaivestone.javax.awt.print.TranslatedPrintable;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;

public class SimplePaginator
implements Pageable {
    private int numPagesX;
    private int numPagesY;
    private Printable printable;
    private PageFormat pageFormat;

    public SimplePaginator(float width, float height, Printable painter, PageFormat format) {
        this.setPrintable(painter);
        this.setPageFormat(format);
        this.setSize(width, height);
    }

    protected SimplePaginator() {
    }

    protected void setSize(float width, float height) {
        System.out.println("SimplePaginator.setSize: " + width + ", " + height);
        double pageHeight = this.getPageFormat().getImageableHeight();
        double pageWidth = this.getPageFormat().getImageableWidth();
        this.setNumberOfPagesX((int)(((double)width + pageWidth - 1.0) / pageWidth));
        this.setNumberOfPagesY((int)(((double)height + pageHeight - 1.0) / pageHeight));
        System.out.println("  getImageableWidth: " + pageWidth);
        System.out.println("  getImageableHeight: " + pageHeight);
        System.out.println("  numPagesX: " + this.numPagesX);
        System.out.println("  numPagesY: " + this.numPagesY);
        System.out.println("  numPages: " + this.getNumberOfPages());
    }

    protected void setPrintable(Printable painter) {
        this.printable = painter;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    private void setNumberOfPagesX(int count) {
        this.numPagesX = count;
    }

    private void setNumberOfPagesY(int count) {
        this.numPagesY = count;
    }

    @Override
    public int getNumberOfPages() {
        return this.getNumberOfPagesX() * this.getNumberOfPagesY();
    }

    public int getNumberOfPagesX() {
        return this.numPagesX;
    }

    public int getNumberOfPagesY() {
        return this.numPagesY;
    }

    protected PageFormat getPageFormat() {
        return this.pageFormat;
    }

    @Override
    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex > this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("pageIndex " + pageIndex + " >= numPages " + this.getNumberOfPages());
        }
        return this.getPageFormat();
    }

    @Override
    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        if (pageIndex > this.getNumberOfPages()) {
            throw new IndexOutOfBoundsException("pageIndex " + pageIndex + " >= numPages " + this.getNumberOfPages());
        }
        double originX = (double)(pageIndex % this.getNumberOfPagesX()) * this.getPageFormat().getImageableWidth();
        double originY = (double)(pageIndex / this.getNumberOfPagesX()) * this.getPageFormat().getImageableHeight();
        Point2D.Double origin = new Point2D.Double(originX, originY);
        return new TranslatedPrintable(this.printable, origin);
    }
}

