/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.io;

import com.glaivestone.javax.util.StatusValue;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FileSystemOperationResult
extends StatusValue {
    protected static final int UNRESOLVED_STATUS = -1;
    int nAffectedElements = 0;
    protected List<Throwable> problems = null;

    public FileSystemOperationResult() {
        super(-1);
    }

    protected int determineResultStatus() {
        if (this.getNumberOfProblems() == 0) {
            return 0;
        }
        if (this.getNumberOfAffectedElements() == 0) {
            return 1;
        }
        return 2;
    }

    public int getNumberOfAffectedElements() {
        return this.nAffectedElements;
    }

    public int getNumberOfProblems() {
        return this.problems == null ? 0 : this.problems.size();
    }

    public List<Throwable> getProblems() {
        return this.problems;
    }

    public void reportProblem(File aFileSystemElement, Throwable ex) {
        if (this.problems == null) {
            this.problems = new ArrayList<Throwable>();
        }
        this.problems.add(ex);
    }

    @Override
    public int getStatusCode() {
        if (super.getStatusCode() == -1) {
            this.setStatus(this.determineResultStatus());
        }
        return super.getStatusCode();
    }

    public void reportSuccess(File aFileSystemElement) {
        ++this.nAffectedElements;
    }
}

