/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.io;

import com.glaivestone.javax.io.FileSystemOperationResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;

public class FileSystemServices {
    public static final int DEFAULT_COPY_BUFFER_SIZE = 512;
    protected static final boolean VALIDATE_COPY = false;
    public static FileSystemServices current = new FileSystemServices(512);
    protected int copyBufferSize;
    protected byte[] copyBuffer;

    public FileSystemServices(int copyBufferSize) {
        this.setCopyBufferSize(copyBufferSize);
    }

    public static FileSystemServices getCurrent() {
        return current;
    }

    public void clearCopyBuffer() {
        this.copyBuffer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void copyFile(File sourceFile, File destination) throws FileNotFoundException, IOException {
        File destFile;
        File file = destFile = this.isRealDirectory(destination) ? new File(destination, sourceFile.getName()) : destination;
        if (!destFile.exists()) {
            destFile.createNewFile();
        }
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[this.copyBufferSize];
        }
        FileInputStream fsSource = new FileInputStream(sourceFile);
        FileOutputStream fsDest = new FileOutputStream(destFile);
        try {
            int nBytesRead;
            for (long nBytesLeft = sourceFile.length(); nBytesLeft > 0L; nBytesLeft -= (long)nBytesRead) {
                nBytesRead = fsSource.read(this.copyBuffer);
                fsDest.write(this.copyBuffer, 0, nBytesRead);
            }
        }
        finally {
            fsSource.close();
            fsDest.close();
        }
        destFile.setLastModified(sourceFile.lastModified());
    }

    public FileSystemOperationResult deleteAllFiles(File aDirectory) {
        this.validateDirectory(aDirectory);
        FileSystemOperationResult operationStatus = new FileSystemOperationResult();
        this.deleteAllFiles(aDirectory, operationStatus);
        return operationStatus;
    }

    protected void deleteAllFiles(File aDirectory, FileSystemOperationResult operationStatus) {
        File[] elements = aDirectory.listFiles();
        this.deleteFiles(elements, operationStatus);
        for (int i = 0; i < elements.length; ++i) {
            File fsElement = elements[i];
            if (!fsElement.isDirectory()) continue;
            this.deleteAllFiles(fsElement, operationStatus);
        }
    }

    protected void deleteFileSystemElement(File fsElement, FileSystemOperationResult operationStatus) {
        boolean deleted;
        try {
            deleted = fsElement.delete();
        }
        catch (SecurityException ex) {
            operationStatus.reportProblem(fsElement, ex);
            return;
        }
        if (!deleted) {
            operationStatus.reportProblem(fsElement, new IOException("Delete failed (unknown file system problem): " + fsElement.getAbsolutePath()));
        } else {
            operationStatus.reportSuccess(fsElement);
        }
    }

    public FileSystemOperationResult deleteDirectory(File aDirectory) {
        this.validateDirectory(aDirectory);
        FileSystemOperationResult operationStatus = new FileSystemOperationResult();
        this.deleteDirectory(aDirectory, operationStatus);
        return operationStatus;
    }

    protected void deleteDirectory(File aDirectory, FileSystemOperationResult operationStatus) {
        File[] elements = aDirectory.listFiles();
        this.deleteFiles(elements, operationStatus);
        for (int i = 0; i < elements.length; ++i) {
            File fsElement = elements[i];
            if (!fsElement.isDirectory()) continue;
            this.deleteDirectory(fsElement, operationStatus);
        }
        this.deleteFileSystemElement(aDirectory, operationStatus);
    }

    public FileSystemOperationResult deleteEmptyDirectories(File aDirectory) {
        this.validateDirectory(aDirectory);
        FileSystemOperationResult operationStatus = new FileSystemOperationResult();
        this.deleteEmptyDirectories(aDirectory, true, operationStatus);
        return operationStatus;
    }

    protected void deleteEmptyDirectories(File aDirectory, boolean deleteThisDirectory, FileSystemOperationResult operationStatus) {
        File[] elements = aDirectory.listFiles();
        for (int i = 0; i < elements.length; ++i) {
            File fsElement = elements[i];
            if (!fsElement.isDirectory()) continue;
            this.deleteEmptyDirectories(fsElement, true, operationStatus);
        }
        if (deleteThisDirectory && this.getDirectorySize(aDirectory) == 0) {
            this.deleteFileSystemElement(aDirectory, operationStatus);
        }
    }

    public FileSystemOperationResult deleteEmptySubdirectories(File aDirectory) {
        this.validateDirectory(aDirectory);
        FileSystemOperationResult operationStatus = new FileSystemOperationResult();
        this.deleteEmptyDirectories(aDirectory, false, operationStatus);
        return operationStatus;
    }

    public FileSystemOperationResult deleteFiles(File aDirectory) {
        this.validateDirectory(aDirectory);
        FileSystemOperationResult operationStatus = new FileSystemOperationResult();
        File[] elements = aDirectory.listFiles();
        this.deleteFiles(elements, operationStatus);
        return operationStatus;
    }

    protected void deleteFiles(File[] elements, FileSystemOperationResult operationStatus) {
        for (int i = 0; i < elements.length; ++i) {
            File fsElement = elements[i];
            if (!fsElement.isFile()) continue;
            this.deleteFileSystemElement(fsElement, operationStatus);
        }
    }

    public int getDirectorySize(File aDirectory) {
        this.validateDirectory(aDirectory);
        return aDirectory.list().length;
    }

    public String getFileContents(File aFile) throws FileNotFoundException, IOException {
        return String.valueOf(this.getFileContentsAsCharArray(aFile));
    }

    public String getFileContents(String pathname) throws FileNotFoundException, IOException {
        return this.getFileContents(new File(pathname));
    }

    public char[] getFileContentsAsCharArray(File aFile) throws FileNotFoundException, IOException {
        int nCharsRead;
        this.validateFile(aFile);
        int nBytes = (int)aFile.length();
        char[] buffer = new char[nBytes];
        FileReader reader = new FileReader(aFile);
        for (int nCharsSoFar = nCharsRead = reader.read(buffer); nCharsSoFar < nBytes; nCharsSoFar += nCharsRead) {
            nCharsRead = reader.read(buffer, nCharsSoFar, nBytes - nCharsSoFar);
        }
        reader.close();
        return buffer;
    }

    public boolean isRealDirectory(File fileSystemElement) {
        return fileSystemElement.exists() && fileSystemElement.isDirectory();
    }

    public File realizeDirectory(File aDirectory, String relativePathName) throws IOException {
        return this.realizeDirectory(new File(aDirectory, relativePathName));
    }

    public File realizeDirectory(File aDirectory) throws IOException {
        boolean created;
        if (aDirectory.exists()) {
            if (!aDirectory.isDirectory()) {
                throw new IllegalArgumentException("Not a directory: " + aDirectory);
            }
            return aDirectory;
        }
        try {
            created = aDirectory.mkdirs();
        }
        catch (SecurityException ex) {
            throw new IOException("Directory creation failed (security exception): " + ex.getLocalizedMessage());
        }
        if (!created) {
            throw new IOException("Directory creation failed (unknown file system problem)");
        }
        return aDirectory;
    }

    public synchronized void setCopyBufferSize(int nBytes) {
        this.copyBufferSize = nBytes;
        this.clearCopyBuffer();
    }

    protected void validateDirectory(File fsElement) {
        if (!this.isRealDirectory(fsElement)) {
            throw new IllegalArgumentException("Not a directory: " + fsElement);
        }
    }

    protected void validateFile(File fsElement) {
        if (!fsElement.isFile()) {
            throw new IllegalArgumentException("Not a file: " + fsElement);
        }
    }
}

