/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing;

import java.awt.Rectangle;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class SwingServices {
    public static SwingServices current = new SwingServices();

    protected SwingServices() {
    }

    public Rectangle adjustTargetHeight(Rectangle targetRect, int dyAbove, int dyBelow) {
        int x = targetRect.x;
        int y = targetRect.y;
        int width = targetRect.width;
        int height = targetRect.height;
        int dy = Math.min(dyAbove, y);
        height += dy;
        return new Rectangle(x, y -= dy, width, height += dyBelow);
    }

    protected Rectangle adjustElementRectangle(Rectangle elementRect, int index, int nElements, int nElementsAbove, int nElementsBelow) {
        int elementHeight = elementRect.height;
        return this.adjustTargetHeight(elementRect, Math.min(nElementsAbove, index) * elementHeight, Math.min(nElementsBelow, nElements - (index + 1)) * elementHeight);
    }

    public void applyLabelLookAndFeel(JTextArea aTextItem) {
        aTextItem.setLineWrap(true);
        aTextItem.setWrapStyleWord(true);
        this.applyReadOnlyLookAndFeel(aTextItem);
        LookAndFeel.installBorder(aTextItem, "Label.border");
    }

    public void applyReadOnlyLookAndFeel(JTextComponent aTextItem) {
        aTextItem.setEditable(false);
        aTextItem.setHighlighter(null);
        LookAndFeel.installColorsAndFont(aTextItem, "Label.background", "Label.foreground", "Label.font");
    }

    public int getLineStartOffset(int offset, JTextArea textComponent) {
        try {
            return textComponent.getLineStartOffset(textComponent.getLineOfOffset(offset));
        }
        catch (BadLocationException ex) {
            return -1;
        }
    }

    public boolean scrollItemIntoView(int index, JList listComponent) {
        if (index < 1) {
            return false;
        }
        Rectangle itemRect = listComponent.getCellBounds(index, index);
        if (index > 0) {
            itemRect.translate(0, 0 - itemRect.height);
        }
        listComponent.scrollRectToVisible(itemRect);
        return true;
    }

    public boolean scrollRowIntoView(int index, JTable tableComponent) {
        return this.scrollRowIntoView(index, tableComponent, 2, 2);
    }

    public boolean scrollRowIntoView(int index, JTable tableComponent, int rowsAbove, int rowsBelow) {
        if (index == -1) {
            return false;
        }
        Rectangle targetRect = tableComponent.getCellRect(index, 0, true);
        targetRect = this.adjustElementRectangle(targetRect, index, tableComponent.getRowCount(), rowsAbove, rowsBelow);
        tableComponent.scrollRectToVisible(targetRect);
        return true;
    }

    public boolean scrollSelectionIntoView(JList listComponent) {
        int selectedIndex = listComponent.getMinSelectionIndex();
        if (selectedIndex < 0) {
            return false;
        }
        return this.scrollItemIntoView(selectedIndex, listComponent);
    }

    public boolean scrollSelectionIntoView(JTable tableComponent) {
        int selectedIndex = tableComponent.getSelectionModel().getMinSelectionIndex();
        if (selectedIndex < 0) {
            return false;
        }
        return this.scrollRowIntoView(selectedIndex, tableComponent);
    }

    public boolean scrollTextIntoView(int offset, JScrollPane textViewScroller) {
        return this.scrollTextIntoView(offset, textViewScroller, 0, 6);
    }

    public boolean scrollTextIntoView(int offset, JScrollPane textViewScroller, int linesAbove, int linesBelow) {
        Rectangle targetRect;
        JViewport textViewport = textViewScroller.getViewport();
        JTextComponent textComponent = (JTextComponent)textViewport.getView();
        try {
            targetRect = textComponent.modelToView(offset);
        }
        catch (BadLocationException ex) {
            return false;
        }
        if (targetRect == null) {
            return false;
        }
        if (textViewport.getViewRect().contains(targetRect)) {
            return false;
        }
        int lineHeight = targetRect.height;
        targetRect = this.adjustTargetHeight(targetRect, linesAbove * lineHeight, linesBelow * lineHeight);
        textViewport.scrollRectToVisible(targetRect);
        return true;
    }
}

