/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.swing.print;

import com.glaivestone.javax.awt.print.SimplePaginator;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;

public class JComponentPrinter
extends SimplePaginator
implements Printable {
    private static final boolean SYMMETRIC_SCALING = true;
    private static final boolean ASYMMETRIC_SCALING = false;
    private double scaleX;
    private double scaleY;
    private JComponent component;

    public JComponentPrinter(JComponent component, PageFormat format) {
        this.setPageFormat(format);
        this.setPrintable(this);
        this.setJComponent(component);
        Rectangle componentBounds = component.getBounds(null);
        this.setSize(componentBounds.width, componentBounds.height);
        this.setScale(1.0, 1.0);
    }

    public JComponentPrinter(JComponent component) {
        this(component, new PageFormat());
    }

    public double getScaleX() {
        return this.scaleX;
    }

    public double getScaleY() {
        return this.scaleY;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        Rectangle componentBounds = this.getJComponent().getBounds(null);
        g2.translate(-componentBounds.x, -componentBounds.y);
        g2.scale(this.getScaleX(), this.getScaleY());
        this.getJComponent().printAll(g2);
        return 0;
    }

    void setJComponent(JComponent component) {
        this.component = component;
    }

    JComponent getJComponent() {
        return this.component;
    }

    public void setScale(double scaleX, double scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void scaleToFitX() {
        double scaleX;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.getJComponent().getBounds(null);
        double scaleY = scaleX = format.getImageableWidth() / (double)componentBounds.width;
        if (scaleX < 1.0) {
            this.setSize((float)format.getImageableWidth(), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFitY() {
        double scaleY;
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.getJComponent().getBounds(null);
        double scaleX = scaleY = format.getImageableHeight() / (double)componentBounds.height;
        if (scaleY < 1.0) {
            this.setSize((float)((double)componentBounds.width * scaleX), (float)format.getImageableHeight());
            this.setScale(scaleX, scaleY);
        }
    }

    public void scaleToFit(boolean useSymmetricScaling) {
        PageFormat format = this.getPageFormat();
        Rectangle componentBounds = this.getJComponent().getBounds(null);
        double scaleX = format.getImageableWidth() / (double)componentBounds.width;
        double scaleY = format.getImageableHeight() / (double)componentBounds.height;
        if (scaleX < 1.0 || scaleY < 1.0) {
            if (useSymmetricScaling) {
                if (scaleX < scaleY) {
                    scaleY = scaleX;
                } else {
                    scaleX = scaleY;
                }
            }
            this.setSize((float)((double)componentBounds.width * scaleX), (float)((double)componentBounds.height * scaleY));
            this.setScale(scaleX, scaleY);
        }
    }
}

