/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.javax.util;

public class StatusValue {
    public static final int SUCCEEDED = 0;
    public static final int FAILED = 1;
    public static final int PARTIALLY_SUCCEEDED = 2;
    public static final StatusValue SUCCESS_RESULT = new StatusValue(0);
    protected int statusCode;
    protected String message;

    public StatusValue(int statusCode) {
        this(statusCode, null);
    }

    public StatusValue(int statusCode, String message) {
        this.statusCode = statusCode;
        this.message = message;
    }

    protected void disallowSuccesConstantChanges(String attribute) {
        if (this.isSuccessConstant()) {
            throw new IllegalStateException("Not allowed to change the " + attribute + " of a SUCCESS_RESULT constant");
        }
    }

    public boolean failed() {
        return this.getStatusCode() == 1;
    }

    protected boolean isSuccessConstant() {
        return this == SUCCESS_RESULT;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void setStatus(int statusCode) {
        this.disallowSuccesConstantChanges("status");
        this.statusCode = statusCode;
    }

    public boolean succeeded() {
        return this.succeededCompletely();
    }

    public boolean succeededCompletely() {
        return this.getStatusCode() == 0;
    }

    public boolean succeededPartially() {
        return this.getStatusCode() == 2;
    }
}

