/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.mv;

import com.glaivestone.javax.execution.SessionManager;
import com.glaivestone.javax.util.EventManager;
import com.glaivestone.mv.ApplicationView;
import com.glaivestone.mv.UISessionManager;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

public class ApplicationModel
extends EventManager {
    public static Collection<ApplicationView> getAllViews(ApplicationModel appModel) {
        ArrayList<ApplicationView> views = new ArrayList<ApplicationView>();
        for (Window aWindow : UISessionManager.current.getOpenWindows()) {
            if (!(aWindow instanceof ApplicationView) || !appModel.equals(((ApplicationView)((Object)aWindow)).getAppModel())) continue;
            views.add((ApplicationView)((Object)aWindow));
        }
        return views;
    }

    public static Collection<ApplicationView> getAllViews(Class<?> appModelClass) {
        ArrayList<ApplicationView> views = new ArrayList<ApplicationView>();
        for (Window aWindow : UISessionManager.current.getOpenWindows()) {
            if (!(aWindow instanceof ApplicationView) || !appModelClass.equals(((ApplicationView)((Object)aWindow)).getAppModel().getClass())) continue;
            views.add((ApplicationView)((Object)aWindow));
        }
        return views;
    }

    public void closeWindow(Window aWindow) {
        this.windowClosing(aWindow);
        if (this.shouldDestroyWindowOnClose(aWindow)) {
            aWindow.dispose();
        } else {
            aWindow.setVisible(false);
            this.windowClosed(aWindow);
        }
    }

    protected void configureWindow(Window aWindow) {
        this.installAppModel(aWindow);
        this.configureWindowOptions(aWindow);
        this.configureWindowConnections(aWindow);
    }

    protected void configureWindowOptions(Window aWindow) {
    }

    protected void configureWindowConnections(Window aWindow) {
        this.configureWindowListener(aWindow);
    }

    protected void configureWindowListener(Window aWindow) {
        aWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                ApplicationModel.this.windowOpened(event.getWindow());
            }

            @Override
            public void windowClosing(WindowEvent event) {
                ApplicationModel.this.requestCloseWindow(event.getWindow());
            }

            @Override
            public void windowClosed(WindowEvent event) {
                ApplicationModel.this.windowClosed(event.getWindow());
            }
        });
    }

    protected Window constructWindow() {
        return this.constructWindow(this.defaultWindowClassName());
    }

    protected Window constructWindow(String windowClassName) {
        if (windowClassName == null) {
            return null;
        }
        try {
            return (Window)Class.forName(windowClassName).newInstance();
        }
        catch (Exception ex) {
            this.reportWindowCreationFailure(ex, windowClassName);
            return null;
        }
    }

    protected Window constructWindow(String windowClassName, Class<?> parmType, Object arg) {
        if (windowClassName == null) {
            return null;
        }
        try {
            Class<?> windowClass = Class.forName(windowClassName);
            Class[] parmTypes = new Class[]{parmType};
            Object[] args = new Object[]{arg};
            Constructor<?> aConstructor = windowClass.getConstructor(parmTypes);
            return (Window)aConstructor.newInstance(args);
        }
        catch (Exception ex) {
            this.reportWindowCreationFailure(ex, windowClassName);
            return null;
        }
    }

    protected Window constructWindow(String windowClassName, Window aWindow) {
        if (aWindow instanceof Frame) {
            return this.constructWindow(windowClassName, Frame.class, aWindow);
        }
        if (aWindow instanceof Dialog) {
            return this.constructWindow(windowClassName, Dialog.class, aWindow);
        }
        return this.constructWindow(windowClassName, aWindow.getClass(), aWindow);
    }

    protected String defaultWindowClassName() {
        return null;
    }

    public Collection<ApplicationView> getAllViews() {
        return ApplicationModel.getAllViews(this);
    }

    public ApplicationView getView() {
        Collection<ApplicationView> views = this.getAllViews();
        int nViews = views.size();
        if (nViews == 0) {
            return null;
        }
        if (nViews > 1) {
            // empty if block
        }
        return views.iterator().next();
    }

    public Window getWindow() {
        ApplicationView aView = this.getView();
        return aView == null ? null : aView.getMainWindow();
    }

    protected void displayWindow(Window aWindow) {
        this.windowOpening(aWindow);
        aWindow.setVisible(true);
    }

    protected void installAppModel(Window aWindow) {
        if (aWindow instanceof ApplicationView) {
            ((ApplicationView)((Object)aWindow)).setAppModel(this);
        }
    }

    protected void notifySessionManagerOfWindowClosed(Window aWindow) {
        UISessionManager.current.windowClosed(aWindow);
    }

    protected void notifySessionManagerOfWindowClosing(Window aWindow) {
        UISessionManager.current.windowClosing(aWindow);
    }

    protected boolean notifySessionManagerOfWindowCloseRequest(Window aWindow) {
        return UISessionManager.current.confirmWindowClose(aWindow);
    }

    protected void notifySessionManagerOfWindowOpened(Window aWindow) {
        UISessionManager.current.windowOpened(aWindow);
    }

    public Window openWindow() {
        Window aWindow = this.constructWindow();
        if (aWindow == null) {
            System.err.println("ERROR: No window class for " + this);
            return null;
        }
        return this.openWindow(aWindow);
    }

    public Window openWindow(Window aWindow) {
        this.configureWindow(aWindow);
        this.displayWindow(aWindow);
        return aWindow;
    }

    protected Window reopenWindow(Window aWindow) {
        this.displayWindow(aWindow);
        this.windowOpened(aWindow);
        return aWindow;
    }

    public boolean requestCloseWindow(Window aWindow) {
        if (!this.shouldAllowCloseWindow(aWindow)) {
            return false;
        }
        this.closeWindow(aWindow);
        return true;
    }

    protected void reportResourceNotFound(String resourceName) {
    }

    protected void reportWindowCreationFailure(Exception ex, String windowClassName) {
        System.err.println("Unable to construct window for " + this.getClass().getName() + ": " + windowClassName);
        ex.printStackTrace();
    }

    public URL resolveResourceReference(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        URL anURL = SessionManager.current.getSystemResource(resourceName);
        if (anURL == null) {
            this.reportResourceNotFound(resourceName);
        }
        return anURL;
    }

    protected boolean shouldAllowCloseWindow(Window aWindow) {
        return this.notifySessionManagerOfWindowCloseRequest(aWindow);
    }

    protected boolean shouldDestroyWindowOnClose(Window aWindow) {
        return true;
    }

    protected void windowClosing(Window aWindow) {
        this.notifySessionManagerOfWindowClosing(aWindow);
    }

    protected void windowClosed(Window aWindow) {
        this.notifySessionManagerOfWindowClosed(aWindow);
    }

    protected void windowOpening(Window aWindow) {
    }

    protected void windowOpened(Window aWindow) {
        this.notifySessionManagerOfWindowOpened(aWindow);
    }
}

