/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text;

import com.glaivestone.mv.ApplicationView;
import com.glaivestone.toolbox.mv.text.BasicTextWindow;
import com.glaivestone.toolbox.mv.text.swing.PlainTextPrintTargetDocument;
import java.awt.Window;
import java.io.PrintStream;
import java.io.PrintWriter;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class TextLogWindow
extends BasicTextWindow {
    public static String DEFAULT_WINDOW_TITLE = "Log Window";
    private static boolean TESTING_FROM_MAIN = false;

    public TextLogWindow() {
        this(DEFAULT_WINDOW_TITLE);
    }

    public TextLogWindow(String windowTitle) {
        super(windowTitle, TEXT_PROPERTIES_UNSTYLED_LOG);
    }

    public static TextLogWindow createWindow(String windowTitle) {
        TextLogWindow aWindow = new TextLogWindow(windowTitle);
        aWindow.openWindow();
        return aWindow;
    }

    public static ApplicationView open() {
        return (ApplicationView)((Object)new TextLogWindow().openWindow());
    }

    public static ApplicationView open(String windowTitle) {
        return (ApplicationView)((Object)new TextLogWindow(windowTitle).openWindow());
    }

    @Override
    protected Document constructTextHolder() {
        return new PlainTextPrintTargetDocument();
    }

    @Override
    protected String defaultWindowClassName() {
        return "com.glaivestone.toolbox.mv.text.swing.SimplePrintTargetTextWindowView";
    }

    public PrintStream getPrintStream() {
        return ((PlainTextPrintTargetDocument)this.getTextHolder()).getPrintStream();
    }

    public PrintWriter getPrintWriter() {
        return ((PlainTextPrintTargetDocument)this.getTextHolder()).getPrintWriter();
    }

    public void flush() {
        this.getPrintWriter().flush();
    }

    public void print(String text) {
        this.getPrintWriter().print(text);
    }

    public void println() {
        this.getPrintWriter().println();
    }

    public void println(String text) {
        this.getPrintWriter().println(text);
    }

    @Override
    protected void windowOpened(Window aWindow) {
        super.windowOpened(aWindow);
        if (TESTING_FROM_MAIN) {
            this.println("Log window windowOpened event handler [" + this + "]");
            Runnable logger = new Runnable(){

                @Override
                public void run() {
                    TextLogWindow.this.println("Begin some logging...");
                    for (int i = 0; i < 30; ++i) {
                        TextLogWindow.this.println("...line " + i);
                    }
                    TextLogWindow.this.println("..done");
                }
            };
            this.println("Forking new thread to log some text...");
            SwingUtilities.invokeLater(logger);
        }
    }

    public static void main(String[] args) {
        TESTING_FROM_MAIN = true;
        TextLogWindow tw = new TextLogWindow(DEFAULT_WINDOW_TITLE + " - TEST");
        tw.setText("Log window test.\n\nWe have created: " + NEW_LINE + tw);
        tw.openWindow();
    }
}

