/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.mv.text.swing;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.InstanceMethodAction;
import com.glaivestone.javax.swing.SwingServices;
import com.glaivestone.toolbox.mv.text.swing.SimpleTextWindowView;
import java.awt.EventQueue;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class SimplePrintTargetTextWindowView
extends SimpleTextWindowView {
    protected static final int NULL_OFFSET = -1;
    protected int appendedTextOffset = -1;
    protected EvaluableAction getLineStartOffsetAction;

    @Override
    protected void configureConnections() {
        super.configureConnections();
        final Document textModel = this.getTextHolder();
        textModel.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                int offsetEndChar = textModel.getLength();
                if (event.getOffset() + event.getLength() >= offsetEndChar) {
                    SimplePrintTargetTextWindowView.this.textAppended(offsetEndChar);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
            }
        });
    }

    @Override
    protected JTextComponent constructUnstyledTextComponent() {
        JTextComponent textArea = super.constructUnstyledTextComponent();
        this.getLineStartOffsetAction = InstanceMethodAction.create((Object)this, "getUnstyleLineStartOffset", new Class[]{Integer.TYPE});
        return textArea;
    }

    public int getUnstyleLineStartOffset(int offset) {
        return SwingServices.current.getLineStartOffset(offset, (JTextArea)this.getTextComponent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scrollAppendedTextIntoView() {
        int offset;
        SimplePrintTargetTextWindowView simplePrintTargetTextWindowView = this;
        synchronized (simplePrintTargetTextWindowView) {
            offset = this.appendedTextOffset;
            this.appendedTextOffset = -1;
        }
        if (offset == -1) {
            return;
        }
        this.scrollAppendedTextIntoView(offset);
    }

    protected void scrollAppendedTextIntoView(int offset) {
        int targetOffset = this.getLineStartOffsetAction != null ? (Integer)this.getLineStartOffsetAction.evaluate(new Integer(offset)) : offset;
        this.scrollTextIntoView(targetOffset);
    }

    protected void scrollTextIntoView(int offset) {
        SwingServices.current.scrollTextIntoView(offset, this.textPaneScroller, 1, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void textAppended(int offset) {
        boolean scrollAppendedTextRequestQueued;
        SimplePrintTargetTextWindowView simplePrintTargetTextWindowView = this;
        synchronized (simplePrintTargetTextWindowView) {
            scrollAppendedTextRequestQueued = this.appendedTextOffset != -1;
            this.appendedTextOffset = offset;
        }
        if (!scrollAppendedTextRequestQueued) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SimplePrintTargetTextWindowView.this.scrollAppendedTextIntoView();
                }
            });
        }
    }
}

