/*
 * Decompiled with CFR 0.152.
 */
package com.glaivestone.toolbox.text.csv;

import java.util.Arrays;
import java.util.List;

public class CSVFormatter {
    protected String separator;
    protected String stringDelimiter;
    protected boolean reduceEmptyValues;

    public CSVFormatter() {
        this(",");
    }

    public CSVFormatter(String aSeparator) {
        this(aSeparator, "\"");
    }

    public CSVFormatter(String aSeparator, String aDelimiter) {
        this.separator = aSeparator;
        this.stringDelimiter = aDelimiter;
        this.setReduceEmptyValues(true);
    }

    public String asCSVString(String aString) {
        if (aString == null) {
            return "";
        }
        if (aString.length() == 0) {
            return this.reduceEmptyValues ? "" : this.stringDelimiter + this.stringDelimiter;
        }
        boolean includesSeparator = aString.indexOf(this.separator) >= 0;
        int indexDelimiter = aString.indexOf(this.stringDelimiter);
        if (indexDelimiter == -1) {
            return includesSeparator ? this.stringDelimiter + aString + this.stringDelimiter : aString;
        }
        int index = 0;
        StringBuffer sb = new StringBuffer(aString.length() + 4);
        sb.append(this.stringDelimiter);
        while (indexDelimiter != -1) {
            sb.append(aString.substring(index, ++indexDelimiter));
            sb.append(this.stringDelimiter);
            index = indexDelimiter;
            indexDelimiter = aString.indexOf(this.stringDelimiter, index);
        }
        sb.append(aString.substring(index, aString.length()));
        sb.append(this.stringDelimiter);
        return sb.toString();
    }

    public String format(List<String> values) {
        int nValues = values.size();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < nValues; ++i) {
            String aValue = values.get(i);
            if (i > 0) {
                buffer.append(this.separator);
            }
            buffer.append(this.asCSVString(aValue));
        }
        return buffer.toString();
    }

    public String format(String[] values) {
        return this.format(Arrays.asList(values));
    }

    public void setReduceEmptyValues(boolean reduceEmptyValues) {
        this.reduceEmptyValues = reduceEmptyValues;
    }
}

