#!/bin/sh
# Run Alpine Competition Event (ACE) Scoring

_script_ref=`dirname ${0}`
_script_dir=`cd ${_script_ref} && pwd -P`
#BASE_DIR=`dirname ${_script_dir}`
BASE_DIR="${_script_dir}"
#echo "\n_script_dir=${_script_dir}\nBASE_DIR=${BASE_DIR}\n"; exit

STATUS_BAD_ARG=100
##STATUS_NOT_SUPPORTED=101
STATUS_INVALID_REQUEST=64
#STATUS_USER_CANCELLED=65

VERBOSE='no'
DRY_RUN='no'
for arg in "$@"; do
  if [[ "${arg:0:1}" = '-' ]]; then
    if [[ "${arg}" = '--verbose' || "${arg}" = '-v' ]]; then
      VERBOSE='yes'
    elif [[ "${arg}" = '--quiet' || "${arg}" = '-q' ]]; then
      VERBOSE='no'
    elif [[ "${arg}" = '--dry-run' || "${arg}" = '--noexecute' || "${arg}" = '-n' ]]; then
      DRY_RUN='yes'
    else
    echo; echo "***ERROR: unknown option ${arg}"; echo
    exit ${STATUS_INVALID_REQUEST}
    fi
  else
    echo; echo "***ERROR: unknown argument ${arg}"; echo
    exit ${STATUS_INVALID_REQUEST}
  fi
done

if [[ "${DRY_RUN}" == 'yes' ]]; then
  VERBOSE='yes'
fi

if [[ "${VERBOSE}" == 'yes' ]]; then
  echo "\nLaunching ACES (Alpine Competition Event Scoring)"
  echo "cd ${BASE_DIR}/ProgramFiles"
  echo "java -jar lib/aces.jar &"
fi
if [[ "${DRY_RUN}" != 'yes' ]]; then
  cd ${BASE_DIR}/ProgramFiles
  java -jar lib/aces.jar &
  xstat=$?
  if [[ ${xstat} -ne 0 ]]; then
    echo; echo "***ERROR: ACES launch failed (status ${xstat})"; echo
    exit ${xstat}
    fi
  if [[ "${VERBOSE}" == 'yes' ]]; then
    echo '... ok'
    echo '...launch completed.  You may close with terminal window at any time'
  fi
fi
if [[ "${VERBOSE}" == 'yes' ]]; then
  echo
fi

# You may close this terminal window at any time