<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet
	version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<!-- HTML scoring report utilities -->

<!--
 ==============================================================================
 == table generation utilities
 ==============================================================================
-->

<!-- generate N empty table cells; default is 1 -->
<xsl:template name="emptyTableCell">
<xsl:param name="count" select="1"/>
	<xsl:text disable-output-escaping="yes">&lt;td&gt;&amp;nbsp;&lt;/td&gt;</xsl:text>
    <xsl:if test="$count>1">
		<xsl:call-template name="emptyTableCell">
			<xsl:with-param name="count" select="$count - 1"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- generate an empty table row with N columns -->
<xsl:template name="emptyTableRow">
<xsl:param name="nColumns"/>
	<xsl:text disable-output-escaping="yes">&lt;tr&gt;</xsl:text>
	<xsl:call-template name="emptyTableCell">
		<xsl:with-param name="count" select="$nColumns"/>
	</xsl:call-template>
	<xsl:text disable-output-escaping="yes">&lt;/tr&gt;</xsl:text>
</xsl:template>

</xsl:stylesheet>
