/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.io.FileType;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;
import org.ussamasters.aces.racedata.interchange.SplitSecondConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataXMLReader;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;

public class SplitSecondAlpineDataReader
extends RaceDataXMLReader {
    public static final Map<String, RaceType> SST_RACE_TYPES_MAP = new HashMap<String, RaceType>(){
        {
            this.put("1", RaceType.DH);
            this.put("2", RaceType.SL);
            this.put("3", RaceType.GS);
            this.put("4", RaceType.SG);
        }
    };
    public static final String SST_BASE_DATE = "01-Jan-1900";
    protected Element headerSection;
    protected Element dataSection;

    public static boolean isSupportedFormat(String textData) {
        return new SplitSecondAlpineDataReader().isSupportedFormatX(textData);
    }

    protected Map<String, Object> competitorEntryFromElement(Element compElement, String defaultGender) throws RaceDataIOException {
        CompetitorResultValue<?> result;
        String[][] COMP_INFO_SPECS = new String[][]{{"Name", "Name"}, {"Bib", "Bib"}, {"USSANumber", "USSANumber"}, {"Class", "CompClass"}, {"Team", "Team"}, {"YearBorn", "YearOfBirth"}, {"Gender", "MastersSex"}};
        String[][] COMP_TIMES_SPECS = new String[][]{{"FirstRun", "Time1"}, {"SecondRun", "Time2"}};
        HashMap<String, Object> compValues = new HashMap<String, Object>();
        for (int i = 0; i < COMP_INFO_SPECS.length; ++i) {
            String elementName = COMP_INFO_SPECS[i][1];
            String colName = COMP_INFO_SPECS[i][0];
            this.collectCompElementValue(compElement, elementName, colName, compValues);
        }
        if (this.raceType.nRuns == 1) {
            result = this.competitorRunTimeFromElement(compElement.getChild("Time1"));
        } else {
            CompetitorResultValue<?> resultRun1 = this.competitorRunTimeFromElement(compElement.getChild("Time1"));
            CompetitorResultValue<?> resultRun2 = this.competitorRunTimeFromElement(compElement.getChild("Time2"));
            compValues.put("FirstRun", resultRun1);
            compValues.put("SecondRun", resultRun2);
            result = this.competitorResultFromRuns(resultRun1, resultRun2);
        }
        compValues.put("Total", result);
        if (!compValues.containsKey("Gender")) {
            compValues.put("Gender", defaultGender);
        }
        return compValues;
    }

    protected CompetitorResultValue<?> competitorResultFromRuns(CompetitorResultValue<?> resultRun1, CompetitorResultValue<?> resultRun2) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    protected CompetitorResultValue<?> competitorRunTimeFromElement(Element compTimeElement) throws RaceDataIOException {
        if (compTimeElement == null) {
            return UnqualifiedResult.DNS;
        }
        String statusCode = compTimeElement.getChildTextTrim("Status");
        if (statusCode.equals("2")) {
            return UnqualifiedResult.DNF;
        }
        if (statusCode.equals("4")) {
            return UnqualifiedResult.DSQ;
        }
        if (!statusCode.equals("1")) {
            String competitorName = compTimeElement.getParentElement().getChildTextTrim("Name");
            throw new RaceDataIOException("Invalid SST competitor entry: unknown status=" + statusCode + " in " + compTimeElement.getName() + " for " + competitorName);
        }
        return RaceTime.ZERO;
    }

    protected List<Map<String, Object>> getCompetitorEntries() throws RaceDataIOException {
        return this.getCompetitorEntries(this.dataSection);
    }

    protected List<Map<String, Object>> getCompetitorEntries(Element raceDataSection) throws RaceDataIOException {
        List compElements = raceDataSection.getChildren("Comp");
        int nEntries = compElements.size();
        if (nEntries == 0) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> compEntries = new ArrayList<Map<String, Object>>(nEntries);
        String defaultGender = raceDataSection.getName().equals("Men") ? "M" : "F";
        for (Object elt : compElements) {
            Element compElement = (Element)elt;
            Map<String, Object> compEntry = this.competitorEntryFromElement(compElement, defaultGender);
            compEntries.add(compEntry);
        }
        return compEntries;
    }

    @Override
    protected void loadData() throws RaceDataIOException {
        this.validateFormat();
        if (this.loadHeaderOnly) {
            this.headerSection = null;
            this.dataSection = null;
            this.document = null;
            return;
        }
        this.raceType = this.resolveRaceType();
        this.raceDate = this.resolveRaceDate();
        this.raceLocation = this.resolveRaceLocation();
        this.competitorEntries = this.getCompetitorEntries();
    }

    protected RaceDate resolveRaceDate() throws RaceDataIOException {
        String encodedRaceDate = this.headerSection.getChildTextTrim("RaceDate");
        if (encodedRaceDate == null) {
            throw new RaceDataIOException("Invalid SST race data file format: missing <RaceDate>");
        }
        try {
            int nDays = Integer.parseInt(encodedRaceDate);
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException("Invalid SST race data file format: invalid <RaceDate> '" + encodedRaceDate + "'");
        }
        RaceDate raceDate = new RaceDate(SST_BASE_DATE);
        raceDate.getCalendarDate().add(5, nDays -= 2);
        return raceDate;
    }

    protected String resolveRaceLocation() {
        String raceLocationName = this.headerSection.getChildTextTrim("SkiAreaName");
        return raceLocationName;
    }

    protected RaceType resolveRaceType() throws RaceDataIOException {
        int nRunsActual;
        String raceTypeCode = this.headerSection.getChildTextTrim("RaceType");
        String numRuns = this.headerSection.getChildTextTrim("NumRuns");
        if (raceTypeCode == null || numRuns == null) {
            throw new RaceDataIOException("Invalid SST race data file format: no race type in header");
        }
        RaceType raceType = SST_RACE_TYPES_MAP.get(raceTypeCode);
        if (raceType == null) {
            throw new RaceDataIOException("Invalid SST race data file format: unknown displine code '" + raceTypeCode + "'");
        }
        try {
            nRunsActual = Integer.parseInt(numRuns);
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException("Invalid SST race data file format: invalid <NumRuns> '" + numRuns + "'");
        }
        int nRunsStandard = raceType.nRuns;
        if (nRunsActual != nRunsStandard) {
            try {
                raceType = raceType.getRunCountVariant(nRunsActual);
            }
            catch (IllegalArgumentException ex) {
                throw new RaceDataIOException("Invalid SST race data file format: header section contains NumRuns=" + nRunsActual + " (" + nRunsStandard + " expected)");
            }
        }
        return raceType;
    }

    protected void validateFormat() throws RaceDataIOException {
        Element rootElement = this.getRootElement();
        String elementName = "SST_USSA_FIS_Race";
        if (rootElement == null || !rootElement.getName().equals(elementName)) {
            throw new RaceDataIOException("Invalid Split Second race data file: not a <" + elementName + "> document");
        }
        elementName = "CurrentSex";
        String dataSectionName = rootElement.getChildTextTrim(elementName);
        if (dataSectionName == null) {
            throw new RaceDataIOException("Invalid SST race data file: no <" + elementName + "> element");
        }
        this.dataSection = rootElement.getChild(dataSectionName);
        if (this.dataSection == null) {
            throw new RaceDataIOException("Invalid SST race data file format: no <" + dataSectionName + "> element");
        }
        this.headerSection = this.dataSection.getChild("Header");
        if (this.headerSection == null) {
            throw new RaceDataIOException("Invalid SST race data file: no <Header> element");
        }
    }

    public static void describeRace(File aFile, PrintStream out) {
        out.println("SST file: " + aFile.getName());
        try {
            SplitSecondAlpineDataReader dataReader = new SplitSecondAlpineDataReader();
            dataReader.loadFile(aFile);
            RaceType raceType = dataReader.raceType;
            RaceDate raceDate = dataReader.raceDate;
            String location = dataReader.raceLocation;
            out.println("...header: " + (raceType != null ? raceType.name : "<undefined discipline>") + " on " + (raceDate != null ? raceDate.toStandardString() : "<no date>") + " at " + (location != null ? location : "<no location>"));
            out.println("...competitors: " + dataReader.competitorEntries.size());
        }
        catch (Exception ex) {
            out.println("\n***ERROR: " + ex.toString());
        }
    }

    public static void main(String[] args) {
        File sstDir = SplitSecondConstants.SST_ALPINE_DATA_DIR;
        File dataDir = new File(sstDir, "aaaTestSkiXML");
        Object[] files = dataDir.listFiles();
        Arrays.sort(files);
        System.out.println("\n###TEST SST XML READER###");
        for (int i = 0; i < files.length; ++i) {
            Object aFile = files[i];
            String fileName = ((File)aFile).getName();
            if (!((File)aFile).isFile() || !FileType.XML.sameExtension((File)aFile) || !fileName.toLowerCase().startsWith("aaatest")) continue;
            SplitSecondAlpineDataReader.describeRace((File)aFile, System.out);
        }
        System.out.println("...done");
    }
}

