/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.io.FileSystemServices;
import java.io.File;
import java.io.IOException;
import org.ussamasters.aces.racedata.interchange.FISXMLDataImporter;
import org.ussamasters.aces.racedata.interchange.SplitSecondAlpineDataReader;
import org.ussamasters.aces.racedata.interchange.TimingDataFormat;
import org.ussamasters.aces.racedata.interchange.USSASkiDataImporter;

public class TimingDataSource {
    protected String timingData;
    protected TimingDataFormat format;
    protected File backingFile;

    public TimingDataSource(String timingData, TimingDataFormat format, File backingFile) {
        this.timingData = timingData;
        this.format = format;
        this.backingFile = backingFile;
    }

    public File getFile() {
        return this.backingFile;
    }

    public TimingDataFormat getFormat() {
        return this.format;
    }

    public String getTimingData() {
        return this.timingData;
    }

    public static TimingDataFormat determineTimingDataFormat(String timingData) {
        if (USSASkiDataImporter.isSupportedFormat(timingData)) {
            return TimingDataFormat.SKIDATA;
        }
        if (FISXMLDataImporter.isSupportedFormat(timingData)) {
            return TimingDataFormat.FISXML;
        }
        if (SplitSecondAlpineDataReader.isSupportedFormat(timingData)) {
            return TimingDataFormat.FISXML;
        }
        return TimingDataFormat.CSV;
    }

    public static TimingDataSource forFile(File aFile) throws IOException {
        String timingData = FileSystemServices.getCurrent().getFileContents(aFile);
        TimingDataFormat format = TimingDataSource.determineTimingDataFormat(timingData);
        return new TimingDataSource(timingData, format, aFile);
    }
}

