/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.toolbox.text.csv.CSVFormatter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.io.CSVSpecDataReader;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassHelper;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;
import org.ussamasters.aces.racedata.scoring.RaceStandings;

public abstract class TimingSystemDataImporter {
    protected static final Map<String, String> EMPTY_BIBS_MAP = Collections.unmodifiableMap(new HashMap());
    protected RaceDescriptor raceSpecification;
    protected SeasonIdentifier season;
    protected Map<String, String> bibNumberMappingTable;
    protected RaceClassHelper raceClassHelper;
    protected int nRaceRuns;
    protected Class<? extends RaceClass<?>> raceClassClass;
    protected Class<? extends RaceClass<?>> nationalClassClass;
    protected EvaluableAction getRaceClassAction;
    protected EvaluableAction convertNationalClassAction;
    protected Map<String, String> startGroupCodesMap;
    protected RacerList competitorList;
    protected RaceResult raceResult;

    public static UnqualifiedResult computeUnqualifiedResultStatus(CompetitorResultValue<?> firstRun, CompetitorResultValue<?> secondRun, String resultStatus) {
        UnqualifiedResult result = UnqualifiedResult.getConstant(resultStatus);
        if (result == UnqualifiedResult.DNS) {
            if (firstRun.isStarter() && !secondRun.isStarter()) {
                return firstRun.isFinisher() ? UnqualifiedResult.DNF : (UnqualifiedResult)firstRun;
            }
            if (!firstRun.isStarter() && secondRun.isStarter()) {
                return secondRun.isFinisher() ? UnqualifiedResult.DNF : (UnqualifiedResult)secondRun;
            }
        }
        return result;
    }

    public static Map<String, String> loadBibNumberMappingTable(File aFile) throws RaceDataIOException {
        if (aFile == null || !aFile.exists()) {
            return null;
        }
        try {
            List<String[]> specs = CSVSpecDataReader.loadValues(aFile);
            HashMap<String, String> mappingTable = new HashMap<String, String>(specs.size());
            for (String[] spec : specs) {
                mappingTable.put(spec[0].trim(), spec[1].trim());
            }
            return mappingTable;
        }
        catch (IOException | RuntimeException ex) {
            throw new RaceDataIOException(ex, "Error loading bib number import mapping specifications file '" + aFile.getAbsolutePath() + "': " + ex.getMessage());
        }
    }

    public static Map<String, String> loadStartGroupCodeMap(File aFile) throws RaceDataIOException {
        if (aFile == null) {
            return null;
        }
        try {
            List<String[]> specs = CSVSpecDataReader.loadValues(aFile);
            HashMap<String, String> mappingTable = new HashMap<String, String>(specs.size());
            for (String[] spec : specs) {
                mappingTable.put(spec[1].trim(), spec[0]);
            }
            return mappingTable;
        }
        catch (FileNotFoundException ex) {
            throw new RaceDataIOException("Start group mapping specifications file not found: '" + aFile.getAbsolutePath() + "'");
        }
        catch (IOException | RuntimeException ex) {
            throw new RaceDataIOException(ex, "Error loading start group mapping specifications file '" + aFile.getAbsolutePath() + "': " + ex.getMessage());
        }
    }

    protected TimingSystemDataImporter() {
    }

    protected RaceDataIOException constructRacerDataException(String problem, String[] entryValues) {
        String csvString = this.toOriginalInputLine(entryValues);
        return new RaceDataIOException((Object)csvString, problem + ": " + csvString);
    }

    protected RaceDataIOException constructRacerDataException(String problem, String[] entryValues, Throwable ex) {
        String csvString = this.toOriginalInputLine(entryValues);
        return new RaceDataIOException((Object)csvString, problem + " (" + csvString + "): " + ex.getMessage());
    }

    protected RacerList constructEmptyRacerList() {
        return new RacerList(this.season, RaceOrganization.UNKNOWN, this.raceClassClass);
    }

    protected RaceResult constructRaceResult(List<RacerResult> racerResults) {
        RaceResult aRaceResult = new RaceResult(this.raceSpecification, racerResults);
        return RaceStandings.computeCanonicalStandings(aRaceResult);
    }

    protected String getClassNameOfStartGroup(String startGroupCode) {
        return this.startGroupCodesMap.get(startGroupCode);
    }

    public RacerList getCompetitorList() {
        return this.competitorList;
    }

    public RaceResult getRaceResult() {
        return this.raceResult;
    }

    public RaceDescriptor getRaceSpecification() {
        return this.raceSpecification;
    }

    protected void initLoadSpecifications(Class<? extends RaceClass<?>> ageClassClass, SeasonIdentifier season, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap) {
        this.raceSpecification = null;
        this.nRaceRuns = -1;
        this.initSeasonContext(season);
        this.initRaceClassLoadSpecifications(ageClassClass);
        this.setBibNumberMappingTable(bibNumberMappingTable);
        this.setStartGroupCodesMap(startGroupCodesMap);
    }

    protected void initLoadSpecifications(RaceDescriptor aRaceSpecification, SeasonIdentifier season, Map<String, String> bibNumberMappingTable, Map<String, String> startGroupCodesMap) {
        this.raceSpecification = aRaceSpecification;
        this.nRaceRuns = this.raceSpecification.getType().nRuns;
        this.initSeasonContext(season);
        this.initRaceClassLoadSpecifications(this.raceSpecification.getRaceClassClass());
        this.setBibNumberMappingTable(bibNumberMappingTable);
        this.setStartGroupCodesMap(startGroupCodesMap);
    }

    protected void initSeasonContext(SeasonIdentifier season) {
        this.season = season;
        this.raceClassHelper = new RaceClassHelper(this.season);
    }

    protected void initRaceClassLoadSpecifications(Class<? extends RaceClass<?>> aRaceClassClass) {
        this.raceClassClass = aRaceClassClass;
        this.getRaceClassAction = RaceClass.getResolveNameAction(this.raceClassClass);
        RaceClassType raceClassType = this.raceClassHelper.getRaceClassType(this.raceClassClass);
        if (raceClassType.isDivisionClass()) {
            this.nationalClassClass = this.raceClassHelper.getNationalClassClass(this.raceClassClass);
            this.convertNationalClassAction = RaceClass.getConverter(this.nationalClassClass, this.raceClassClass);
        } else if (raceClassType.isInternationalClass()) {
            this.nationalClassClass = this.raceClassHelper.getNationalClassClass(this.raceClassClass);
            this.convertNationalClassAction = RaceClass.getConverter(this.nationalClassClass, this.raceClassClass);
        } else {
            this.nationalClassClass = raceClassType.isNationalClass() ? this.raceClassClass : null;
            this.convertNationalClassAction = null;
        }
    }

    protected String[] parseNameField(String nameField, boolean nameOrderLastFirst) {
        String[] nameElements = RaceDataIOServices.parseRaceEntryName(nameField);
        if (!nameOrderLastFirst) {
            String t = nameElements[0];
            nameElements[0] = nameElements[1];
            nameElements[1] = t;
        }
        return nameElements;
    }

    protected int resolveBibNumber(String fieldValue, String[] entryValues) throws RaceDataIOException {
        int bibNumber;
        String bibNumberString;
        if (fieldValue == null || (bibNumberString = fieldValue.trim()).length() == 0) {
            return -1;
        }
        String mappedBibNumber = this.bibNumberMappingTable.get(bibNumberString);
        if (mappedBibNumber != null) {
            bibNumberString = mappedBibNumber;
        }
        try {
            bibNumber = Integer.parseInt(bibNumberString);
        }
        catch (NumberFormatException ex) {
            throw this.constructRacerDataException("Invalid bib - '" + fieldValue + "' is not a legal bib number", entryValues);
        }
        return bibNumber;
    }

    protected RaceClass<?> resolveNationalClass(Gender gender, int yearBorn) {
        if (gender == null || yearBorn <= 0) {
            return null;
        }
        int currentAge = Racer.computeRacerAge(yearBorn, this.season);
        return this.raceClassHelper.raceClassForAge(gender, currentAge, this.nationalClassClass);
    }

    protected RaceClass<?> resolveRaceClass(Gender gender, String className) {
        return this.resolveRaceClass(gender, className, this.raceClassClass);
    }

    protected RaceClass<?> resolveRaceClass(Gender gender, String className, Class<? extends RaceClass<?>> aRaceClassClass) {
        if (gender == null || className == null || className.trim().isEmpty()) {
            return null;
        }
        return this.raceClassHelper.raceClassFromLiteral(gender.letter + className, aRaceClassClass);
    }

    protected RaceClass<?> resolveRaceClassFromYOB(Gender gender, int yearBorn) {
        return this.resolveRaceClassFromYOB(gender, yearBorn, this.raceClassClass);
    }

    protected RaceClass<?> resolveRaceClassFromYOB(Gender gender, int yearBorn, Class<? extends RaceClass<?>> aRaceClassClass) {
        if (gender == null || yearBorn <= 0) {
            return null;
        }
        int currentAge = Racer.computeRacerAge(yearBorn, this.season);
        return this.raceClassHelper.raceClassForAge(gender, currentAge, aRaceClassClass);
    }

    protected RaceClass<?> resolveRaceClass(String raceClassName) {
        if (raceClassName == null) {
            return null;
        }
        RaceClass<?> raceClass = this.resolveRaceClassName(raceClassName);
        if (raceClass == null) {
            raceClass = this.resolveRaceClassViaNationalClass(raceClassName);
        }
        return raceClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RaceClass<?> resolveRaceClassName(String raceClassName) {
        EvaluableAction evaluableAction = this.getRaceClassAction;
        synchronized (evaluableAction) {
            return (RaceClass)this.getRaceClassAction.evaluate(raceClassName);
        }
    }

    protected RaceClass<?> resolveRaceClassFromStartGroupCode(String startGroupCode, RaceClass<?> raceClass, String[] entryValues) throws RaceDataIOException {
        String startGroupClassName = this.getClassNameOfStartGroup(startGroupCode);
        RaceClass<?> startGroupClass = this.resolveRaceClass(startGroupClassName);
        if (startGroupClass == null) {
            return raceClass;
        }
        if (raceClass == null) {
            return startGroupClass.isUnknown() ? raceClass : startGroupClass;
        }
        if (raceClass.getGender() != startGroupClass.getGender()) {
            throw this.constructRacerDataException("Inconsistent gender on class: start group code '" + startGroupCode + "' mapped to " + startGroupClass + " but class value was " + raceClass, entryValues);
        }
        if (startGroupClass.isUnknown()) {
            return raceClass;
        }
        if (raceClass.isUnknown()) {
            return startGroupClass;
        }
        if (startGroupClass == raceClass) {
            return raceClass;
        }
        if (raceClass.isAgeGroupClass() && startGroupClass.isAbilityGroupClass()) {
            return startGroupClass;
        }
        throw this.constructRacerDataException("Inconsistent class: start group code '" + startGroupCode + "' mapped to " + startGroupClass + " but class value was " + raceClass, entryValues);
    }

    protected RaceClass<?> resolveRaceClassViaNationalClass(String raceClassName) {
        RaceClass<?> usClass;
        if (this.convertNationalClassAction != null && (usClass = this.raceClassHelper.raceClassFromLiteral(raceClassName, this.nationalClassClass)) != null) {
            return (RaceClass)this.convertNationalClassAction.evaluate(usClass);
        }
        return null;
    }

    protected int resolveYearBorn(String fieldValue, String[] entryValues) throws RaceDataIOException {
        try {
            return Racer.parseYear(fieldValue);
        }
        catch (IllegalArgumentException ex) {
            throw this.constructRacerDataException("Invalid year born field: '" + fieldValue + "'", entryValues);
        }
    }

    protected void setBibNumberMappingTable(Map<String, String> bibNumberMappingTable) {
        this.bibNumberMappingTable = bibNumberMappingTable != null ? bibNumberMappingTable : EMPTY_BIBS_MAP;
    }

    protected void setResults(RaceResult raceResult, RacerList competitors) {
        if (competitors != null) {
            competitors.validateEntries();
        }
        this.raceResult = raceResult;
        this.competitorList = competitors;
    }

    protected void setStartGroupCodesMap(Map<String, String> startGroupCodesMap) {
        this.startGroupCodesMap = startGroupCodesMap;
    }

    protected String toOriginalInputLine(String[] entryValues) {
        return new CSVFormatter().format(entryValues);
    }

    protected void validateLoadSpecifications() throws RaceDataIOException {
        if (this.season == null || this.season.startYear <= 0) {
            throw new RaceDataIOException("Invalid season start year: " + this.season);
        }
    }

    protected void validateRaceSpecification(RaceType raceType, RaceDate raceDate, RaceLocation raceLocation) throws RaceDataIOException {
        if (this.raceSpecification.getType() != raceType) {
            throw new RaceDataIOException("Invalid race data: loading " + this.raceSpecification.getType().description + " (loaded results from " + raceType.description + ")");
        }
        if (!this.raceSpecification.getDate().equals(raceDate)) {
            throw new RaceDataIOException("Invalid race data: loading race date " + this.raceSpecification.getDate() + " (loaded results from " + raceDate + ")");
        }
    }
}

