/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.interchange;

import com.glaivestone.toolbox.text.csv.CSVParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.interchange.USSASkiDataConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOException;
import org.ussamasters.aces.racedata.io.RaceDataReader;
import org.ussamasters.aces.racedata.models.RaceDate;
import org.ussamasters.aces.racedata.models.RaceLocation;
import org.ussamasters.aces.racedata.models.RaceType;

public class USSASkiDataReader
extends RaceDataReader {
    protected static final char NULL_STRING_DELIMITER_CHAR = '\u0000';
    protected static final String NULL_SECTION = "[0]";
    protected static final List<String> EMPTY_ENTRIES = Collections.emptyList();
    private boolean loadHeaderOnly = false;
    private BufferedReader reader;
    private CSVParser csvParser = this.constructCSVParser();
    private String currentSection;
    private String currentInputLine;
    private Map<String, List<String[]>> sections;
    private String raceLocation;
    private RaceDate raceDate;
    private RaceType raceType;
    private List<String[]> finisherEntries;
    private List<String[]> nonFinisherEntries;

    protected CSVParser constructCSVParser() {
        return new CSVParser(";", '\u0000');
    }

    public List<String[]> getCompetitorEntries() {
        ArrayList<String[]> allRacerEntries = new ArrayList<String[]>(this.finisherEntries.size() + this.nonFinisherEntries.size());
        allRacerEntries.addAll(this.finisherEntries);
        allRacerEntries.addAll(this.nonFinisherEntries);
        return allRacerEntries;
    }

    public List<String[]> getFinisherEntries() {
        return this.finisherEntries;
    }

    public List<String[]> getNonFinisherEntries() {
        return this.nonFinisherEntries;
    }

    public RaceDate getRaceDate() {
        return this.raceDate;
    }

    public RaceLocation getRaceLocation() {
        RaceLocation location = RaceLocation.getConstant(this.raceLocation);
        if (location == null) {
            location = RaceLocation.UNKNOWN;
        }
        return location;
    }

    public RaceType getRaceType() {
        return this.raceType;
    }

    protected List<String[]> getRacerEntries(String sectionMarker) {
        List<Object> racerEntries = this.getSectionEntries(sectionMarker);
        if (racerEntries == null) {
            racerEntries = Collections.emptyList();
        }
        return racerEntries;
    }

    protected List<String[]> getSectionEntries(String sectionMarker) {
        return this.sections.get(sectionMarker);
    }

    protected int getTag(String[] tokens) {
        return Integer.parseInt(tokens[0]);
    }

    protected boolean isSkiDataFormat(String[] headerLineTokens) {
        return Arrays.equals(headerLineTokens, USSASkiDataConstants.FIS_SKI_DATA_FORMAT_SPECIFICATION_LINE_TOKENS);
    }

    protected boolean isAlpineResultsFormat(String[] headerLineTokens) {
        return Arrays.equals(headerLineTokens, USSASkiDataConstants.ALPINE_RESULTS_SPECIFICATION_LINE_TOKENS) || Arrays.equals(headerLineTokens, USSASkiDataConstants.MASTERS_RESULTS_SPECIFICATION_LINE_TOKENS);
    }

    protected boolean isEmptyOrCommentLine(String inputLine) {
        return inputLine == null || inputLine.length() == 0 || inputLine.charAt(0) == '#';
    }

    protected boolean isSectionMarkerLine(String[] tokens) {
        if (tokens.length != 1) {
            return false;
        }
        String token = tokens[0];
        return token.length() > 2 && token.charAt(0) == '[' && token.charAt(token.length() - 1) == ']';
    }

    @Override
    public void load(Reader aReader) throws RaceDataIOException {
        this.setReader((BufferedReader)aReader);
        try {
            this.loadData();
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException((Exception)ex, this.currentInputLine);
        }
    }

    public void loadData(String textData) throws RaceDataIOException {
        try (BufferedReader aReader = new BufferedReader(new StringReader(textData));){
            this.load(aReader);
        }
        catch (IOException ex) {
            throw new RaceDataIOException((Exception)ex, "I/O Error loading SkiData timing data: " + ex.getMessage());
        }
    }

    protected void loadData() throws RaceDataIOException {
        this.sections = new HashMap<String, List<String[]>>();
        this.currentSection = NULL_SECTION;
        ArrayList<String[]> currentSectionEntries = null;
        this.currentInputLine = null;
        while (this.readNextDataLine() != null) {
            String[] tokens = this.csvParser.getStringValues(this.currentInputLine);
            if (this.isSectionMarkerLine(tokens)) {
                String sectionMarker = tokens[0];
                if (sectionMarker.equals(this.currentSection)) {
                    this.storeSectionEntries(this.currentSection, (List<String[]>)currentSectionEntries);
                    this.currentSection = NULL_SECTION;
                    currentSectionEntries = null;
                    if (!this.loadHeaderOnly || !sectionMarker.equals("[1]")) continue;
                    this.currentInputLine = null;
                    this.validateFormat();
                    return;
                }
                this.currentSection = sectionMarker;
                currentSectionEntries = new ArrayList<String[]>();
                continue;
            }
            if (this.currentSection == NULL_SECTION) {
                throw new RaceDataIOException("Invalid SkiData file: does not start with required header section [1].");
            }
            this.validateSectionEntry(tokens);
            currentSectionEntries.add(tokens);
        }
        this.currentInputLine = null;
        if (this.currentSection != NULL_SECTION) {
            throw new RaceDataIOException("Invalid SkiData file: section " + this.currentSection + " not closed");
        }
        this.validateFormat();
        this.raceType = this.resolveRaceType();
        this.raceDate = this.resolveRaceDate();
        this.raceLocation = this.resolveRaceLocation();
        this.finisherEntries = this.getRacerEntries("[6]");
        this.nonFinisherEntries = this.getRacerEntries("[7]");
    }

    protected String readLine() throws RaceDataIOException {
        try {
            this.currentInputLine = this.reader.readLine();
        }
        catch (IOException ex) {
            throw new RaceDataIOException(ex);
        }
        return this.currentInputLine;
    }

    protected String readNextDataLine() throws RaceDataIOException {
        String inputLine;
        while ((inputLine = this.readLine()) != null) {
            if (this.isEmptyOrCommentLine(inputLine)) continue;
            return inputLine;
        }
        return null;
    }

    protected RaceDate resolveRaceDate() throws RaceDataIOException {
        String sectionMarker = "[2]";
        List<String[]> sectionEntries = this.getSectionEntries(sectionMarker);
        String[] tokens = sectionEntries.get(1);
        String dateString = tokens[2];
        try {
            int day = Integer.parseInt(dateString.substring(0, 2));
            int monthIndex = Integer.parseInt(dateString.substring(3, 5));
            int year = Integer.parseInt(dateString.substring(6));
            return new RaceDate(year, monthIndex, day);
        }
        catch (RuntimeException ex) {
            throw new RaceDataIOException("Invalid race date in race info section " + sectionMarker + ": '" + dateString + "'");
        }
    }

    protected String resolveRaceLocation() {
        String sectionMarker = "[2]";
        List<String[]> sectionEntries = this.getSectionEntries(sectionMarker);
        String[] tokens = sectionEntries.get(2);
        String raceLocationName = tokens[1];
        return raceLocationName;
    }

    protected RaceType resolveRaceType() throws RaceDataIOException {
        String sectionMarker = "[2]";
        List<String[]> sectionEntries = this.getSectionEntries(sectionMarker);
        String[] raceTypeEntry = sectionEntries.get(0);
        String raceTypeName = raceTypeEntry[2];
        RaceType raceType = RaceType.getConstant(raceTypeName);
        if (raceType == null) {
            throw new RaceDataIOException("Invalid race type in race info section " + sectionMarker + ": '" + raceTypeName + "' (entry tag " + 1 + ", field " + 2 + ")");
        }
        int nRunsStandard = raceType.nRuns;
        sectionMarker = "[3]";
        sectionEntries = this.getSectionEntries(sectionMarker);
        if (sectionEntries != null && sectionEntries.size() > 0) {
            String courseInfoTag = "2";
            int nRunsActual = 0;
            for (String[] entry : sectionEntries) {
                if (!entry[0].equals(courseInfoTag)) continue;
                ++nRunsActual;
            }
            if (nRunsActual > 0 && nRunsActual != nRunsStandard) {
                try {
                    raceType = raceType.getRunCountVariant(nRunsActual);
                }
                catch (IllegalArgumentException ex) {
                    throw new RaceDataIOException("Invalid SkiData file format: run info section contains " + nRunsActual + " entries(" + nRunsStandard + " expected)");
                }
            }
        }
        return raceType;
    }

    protected void setReader(BufferedReader reader) {
        this.reader = reader;
    }

    protected void storeSectionEntries(String sectionMarker, List<String[]> sectionEntries) {
        this.sections.put(sectionMarker, sectionEntries);
    }

    protected void validateFormat() throws RaceDataIOException {
        String sectionMarker = "[1]";
        int sectionSize = 2;
        List<String[]> sectionEntries = this.getSectionEntries(sectionMarker);
        this.validateFixedLengthSection(sectionEntries, sectionSize, "header", sectionMarker);
        Object[] tokens = sectionEntries.get(0);
        if (!this.isSkiDataFormat((String[])tokens)) {
            throw new RaceDataIOException("Invalid SkiData file format: not FIS SkiData format");
        }
        tokens = sectionEntries.get(1);
        if (!this.isAlpineResultsFormat((String[])tokens)) {
            throw new RaceDataIOException("Invalid SkiData file format: not alpine ski data results format");
        }
        if (this.loadHeaderOnly) {
            return;
        }
        sectionMarker = "[2]";
        sectionSize = 11;
        sectionEntries = this.getSectionEntries(sectionMarker);
        this.validateFixedLengthSection(sectionEntries, sectionSize, "race info", sectionMarker);
        for (int i = 0; i < sectionSize; ++i) {
            tokens = sectionEntries.get(i);
            if (this.getTag((String[])tokens) == i + 1) continue;
            throw new RaceDataIOException("Invalid SkiData file format:  tag line " + i + " not defined in race info section " + sectionMarker);
        }
        sectionMarker = "[99]";
        sectionSize = 2;
        sectionEntries = this.getSectionEntries(sectionMarker);
        this.validateFixedLengthSection(sectionEntries, sectionSize, "footer", sectionMarker);
        tokens = sectionEntries.get(1);
        if (!Arrays.equals(tokens, USSASkiDataConstants.EOF_MARKER_LINE_TOKENS)) {
            throw new RaceDataIOException("Invalid SkiData file format: footer section missing required !EOF! entry");
        }
    }

    protected void validateFixedLengthSection(List<String[]> sectionEntries, int requiredSize, String sectionDescription, String sectionMarker) throws RaceDataIOException {
        if (sectionEntries == null) {
            throw new RaceDataIOException("Invalid SkiData file format: required " + sectionDescription + " section " + sectionMarker + " not defined");
        }
        int nEntries = sectionEntries.size();
        if (nEntries != requiredSize) {
            throw new RaceDataIOException("Invalid SkiData file format: " + sectionDescription + " section " + sectionMarker + " contains only " + nEntries + " entries (" + requiredSize + " required)");
        }
    }

    protected void validateSectionEntry(String[] tokens) throws RaceDataIOException {
        if (tokens == null || tokens.length == 0) {
            throw new RaceDataIOException("USSA SkiData file reader error: should not be processingempty line in section " + this.currentSection);
        }
        String tag = tokens[0];
        try {
            Integer.parseInt(tag);
        }
        catch (NumberFormatException ex) {
            throw new RaceDataIOException("Invalid entry in section " + this.currentSection + ": first value not a valid line identification tag (" + this.currentInputLine + ")");
        }
    }

    protected void validateVariableLengthSection(List<String[]> sectionEntries, int minSize, String sectionDescription, String sectionMarker) throws RaceDataIOException {
        if (sectionEntries == null) {
            throw new RaceDataIOException("Invalid SkiData file format: required " + sectionDescription + " section " + sectionMarker + " not defined");
        }
        int nEntries = sectionEntries.size();
        if (nEntries < minSize) {
            throw new RaceDataIOException("Invalid SkiData file format: " + sectionDescription + " section " + sectionMarker + " contains only " + nEntries + " entries (at least" + minSize + " expected)");
        }
    }

    public static boolean isSupportedFormat(String textData) {
        USSASkiDataReader reader = new USSASkiDataReader();
        reader.loadHeaderOnly = true;
        try {
            reader.loadData(textData);
        }
        catch (RaceDataIOException ex) {
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String testFileName = "C:\\My Documents\\SplitSecond\\Alpine and Snowboard\\SkiData Files\\MO225-SugarBowlSL.txt";
        USSASkiDataReader reader = new USSASkiDataReader();
        System.out.println("\n***TEST: Load USSA SkiData file\n..." + testFileName);
        try {
            reader.loadFile(testFileName);
            System.out.println("...race location: " + reader.raceLocation);
            System.out.println("...race type: " + reader.getRaceType());
            System.out.println("...race date: " + reader.getRaceDate());
            System.out.println(" ...num finishers: " + reader.getSectionEntries("[6]").size());
            System.out.println("...num non-finishers: " + reader.getSectionEntries("[7]").size());
        }
        catch (RaceDataIOException ex) {
            System.out.println("****ERROR***");
            ex.printStackTrace();
            System.exit(0);
        }
        System.out.println("...done");
    }
}

