/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.io.CSVDataReader;

public class CSVInputDataReader
extends CSVDataReader {
    protected String[] columnNames;

    public CSVInputDataReader(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public CSVInputDataReader(String[] columnNames, boolean filterCommentLines) {
        super(filterCommentLines);
        this.columnNames = columnNames;
    }

    public Map<String, String> asEntryMap(String[] entryValues) {
        HashMap<String, String> entriesMap = new HashMap<String, String>();
        for (int i = 0; i < Math.min(this.columnNames.length, entryValues.length); ++i) {
            entriesMap.put(this.columnNames[i], entryValues[i]);
        }
        return entriesMap;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public List<Map<String, String>> getEntryMaps() {
        if (this.entries == null) {
            return null;
        }
        ArrayList<Map<String, String>> entryMaps = new ArrayList<Map<String, String>>(this.entries.size());
        for (String[] entryValues : this.entries) {
            entryMaps.add(this.asEntryMap(entryValues));
        }
        return entryMaps;
    }

    public static List<String[]> loadValues(File aFile, String[] columnNames) throws IOException, FileNotFoundException {
        CSVInputDataReader aReader = new CSVInputDataReader(columnNames);
        aReader.loadData(aFile);
        return aReader.getEntries();
    }

    public static List<Map<String, String>> loadValueMaps(File aFile, String[] columnNames) throws IOException, FileNotFoundException {
        CSVInputDataReader aReader = new CSVInputDataReader(columnNames);
        aReader.loadData(aFile);
        return aReader.getEntryMaps();
    }
}

