/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.toolbox.text.csv.CSVFormatter;
import java.io.PrintWriter;
import java.io.Writer;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.io.RaceDataWriter;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceType;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.SeriesStandings;

public abstract class CombinedResultTSVWriter
extends RaceDataWriter {
    public static final FileType FILE_TYPE_TSV = FileType.defineConstant("TSV", "tsv", "tab-separated values");
    public static final String FIELD_SEPARATOR = "\t";
    public static final int COLUMN_POSITION_NAME_AFFILIATION = 0;
    public static final int COLUMN_SG = 1;
    public static final int COLUMN_GS = 2;
    public static final int COLUMN_SL = 3;
    public static final int COLUMN_TOTAL = 4;
    public static final int NUM_COLUMNS = 5;
    protected static final String COLUMN_NAMES_COMMENT = "# position/name/affiliation, SG, GS, SL, TOTAL";
    protected static final String NO_FINISH_POSITION_STRING = "-";
    protected static final int[] disciplineColumnMap = CombinedResultTSVWriter.constructDisciplineColumnMap();
    protected SeriesStandings standings;
    protected CSVFormatter formatter;

    protected static int[] constructDisciplineColumnMap() {
        int[] map = new int[RaceType.values().size()];
        for (int i = 0; i < map.length; ++i) {
            map[i] = -1;
        }
        map[RaceType.SG.ord] = 1;
        map[RaceType.GS.ord] = 2;
        map[RaceType.SL.ord] = 3;
        return map;
    }

    protected CombinedResultTSVWriter(SeriesStandings standings) {
        this.standings = standings;
        this.formatter = this.constructCSVFormatter();
    }

    protected String composeRacerNameEntry(NamedRacerResult racerResult) {
        return this.composeRacerNameEntryPositionPrefix(racerResult) + racerResult.getName() + " (" + this.composeRacerNameEntryAffiliationAnnotation(racerResult) + ")";
    }

    protected String composeRacerNameEntryAffiliationAnnotation(NamedRacerResult racerResult) {
        RaceOrganization affiliation = this.getRacerAffiliation(racerResult);
        return affiliation == null || affiliation == RaceOrganization.UNKNOWN ? "UNK" : affiliation.abbreviation;
    }

    protected String composeRacerNameEntryPositionPrefix(NamedRacerResult racerResult) {
        return this.getPositionString(racerResult) + ". ";
    }

    protected abstract String composeRacerScoreEntry(RaceSeriesResult var1);

    protected abstract String composeRaceStartPositionScoreEntry(RaceStartResult var1);

    protected CSVFormatter constructCSVFormatter() {
        return new CSVFormatter(FIELD_SEPARATOR);
    }

    @Override
    protected String constructFileName() {
        return this.composeFileName(RaceDataIOServices.seriesStandingsBaseFileName(this.standings));
    }

    @Override
    protected FileType fileType() {
        return FILE_TYPE_TSV;
    }

    protected String getPositionString(RacerResult racerResult) {
        return racerResult.isFinisher() ? racerResult.getPositionString() : this.getNonFinisherPositionString();
    }

    protected String getNonFinisherPositionString() {
        return NO_FINISH_POSITION_STRING;
    }

    protected RaceOrganization getRacerAffiliation(NamedRacerResult racerResult) {
        return ((RaceSeriesResult)racerResult).getRacer().getAffiliation();
    }

    protected String toCSVString(String[] values) {
        return this.formatter.format(values);
    }

    public void write(PrintWriter pw) {
        this.writeHeader(pw);
        pw.println();
        for (StandingsCategory standingsCategory : this.standings.categories()) {
            this.writeCategoryStandings(standingsCategory, pw);
        }
    }

    protected void writeCategoryHeader(StandingsCategory category, PrintWriter pw) {
        String[] headerEntries = new String[]{this.standings.getOrganizationType().categoryDescription(category), "SG", "GS", "SL", "TOTAL"};
        pw.println(this.toCSVString(headerEntries));
    }

    protected void writeCategoryStandings(StandingsCategory category, PrintWriter pw) {
        CategoryResultsList<RaceSeriesResult> categoryResultsList = this.standings.getCategoryResults(category);
        if (categoryResultsList == null) {
            return;
        }
        this.writeCategoryHeader(category, pw);
        for (RaceSeriesResult racerResult : categoryResultsList) {
            this.writeRacerEntry(racerResult, pw);
        }
        pw.println();
    }

    protected void writeRacerEntry(RaceSeriesResult racerResult, PrintWriter pw) {
        String[] headerEntries = new String[]{this.composeRacerNameEntry(racerResult), "", "", "", this.composeRacerScoreEntry(racerResult)};
        int nRaces = this.standings.getNumberOfRaces();
        for (int i = 0; i < nRaces; ++i) {
            int disciplineIndex = disciplineColumnMap[this.standings.getRace((int)i).getType().ord];
            RaceStartResult startResult = racerResult.getStartResult(i);
            if (startResult == null) continue;
            headerEntries[disciplineIndex] = this.composeRaceStartPositionScoreEntry(startResult);
        }
        pw.println(this.toCSVString(headerEntries));
    }

    protected void writeHeader(PrintWriter pw) {
        pw.print("# ");
        pw.println(this.standings.getDescription());
    }

    @Override
    public void write(Writer aWriter) {
        PrintWriter pw = aWriter instanceof PrintWriter ? (PrintWriter)aWriter : new PrintWriter(aWriter);
        this.write(pw);
    }
}

