/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintWriter;
import java.util.List;
import org.ussamasters.aces.racedata.io.CombinedResultTSVWriter;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.DivisionsCupStandings;

public class DivisionsCupCSVWriter
extends CombinedResultTSVWriter {
    public static DivisionsCupCSVWriter forStandings(DivisionsCupStandings standings) {
        if (!DivisionsCupCSVWriter.isSupported(standings)) {
            return null;
        }
        return new DivisionsCupCSVWriter(standings);
    }

    public static final boolean isSupported(DivisionsCupStandings standings) {
        Class<? extends StandingsCategory> organizingClass = standings.categoryClass();
        if (!organizingClass.equals(RaceOrganization.class)) {
            return false;
        }
        boolean checkSpecialCases = false;
        if (checkSpecialCases) {
            return standings.getNumberOfRaces() == 3;
        }
        return true;
    }

    public DivisionsCupCSVWriter(DivisionsCupStandings standings) {
        super(standings);
    }

    @Override
    protected String composeRacerNameEntryPositionPrefix(NamedRacerResult racerResult) {
        return "";
    }

    @Override
    protected String composeRacerScoreEntry(RaceSeriesResult seriesResult) {
        if (!seriesResult.isQualified()) {
            return "";
        }
        return "" + seriesResult.getDivisionsCupPoints().intValue();
    }

    @Override
    protected String composeRaceStartPositionScoreEntry(RaceStartResult racerResult) {
        if (!racerResult.isFinisher()) {
            return "";
        }
        return "" + racerResult.getDivisionsCupPoints().intValue();
    }

    @Override
    protected void writeHeader(PrintWriter pw) {
        super.writeHeader(pw);
        List<DivisionsCupResult> divisionResultsList = ((DivisionsCupStandings)this.standings).getDivisionResults();
        int nOrganizations = divisionResultsList.size();
        for (int i = 0; i < nOrganizations; ++i) {
            DivisionsCupResult divisionResult = divisionResultsList.get(i);
            StringBuffer sb = new StringBuffer();
            sb.append(divisionResult.isQualified() ? divisionResult.getPositionString() : "-");
            sb.append(". ");
            sb.append(divisionResult.getAffiliation().description);
            sb.append(" - ");
            sb.append("" + divisionResult.getPointsPerStart());
            sb.append(" (" + divisionResult.getNumberOfCompetitors() + " racers");
            sb.append(", " + divisionResult.getNumberOfStarts() + " starts");
            sb.append(", " + divisionResult.getDivisionsCupPoints().intValue() + " points");
            sb.append(")");
            pw.println(sb.toString());
        }
    }
}

