/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.io;

import java.io.PrintWriter;
import org.ussamasters.aces.racedata.io.RaceDataCSVWriter;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;

public class RaceSeriesCSVWriter
extends RaceDataCSVWriter {
    public static final String CURRENT_FORMAT = "USSA Masters Race Calendar (CSV 3.0)";
    private static final String[] CURRENT_FORMAT_COLUMN_NAMES = RaceDataIOConstants.RACE_SERIES_CSV_COLUMN_NAMES_2;
    protected RaceSeries raceSeries;

    public RaceSeriesCSVWriter(RaceSeries raceSeries) {
        this.raceSeries = raceSeries;
    }

    protected String raceToCSVString(RaceIdentifier aRace) {
        return this.toCSVString(RaceDataIOServices.csvValuesFromRace(aRace));
    }

    @Override
    public void write(PrintWriter pw) {
        pw.println(CURRENT_FORMAT);
        pw.println(this.raceSeries.getName());
        this.writeSeasonLine(pw, this.raceSeries.getSeason());
        this.writeRaceClassClassLine(pw, this.raceSeries.getRaceClassClass());
        this.writeWorldCupPointsLine(pw, this.raceSeries.getWorldCupPointsType());
        pw.println();
        this.writeCSVColumnNamesComment(pw, CURRENT_FORMAT_COLUMN_NAMES);
        for (RaceIdentifier race : this.raceSeries.getRaces()) {
            this.writeRace(race, pw);
        }
    }

    protected void writeRace(RaceIdentifier aRace, PrintWriter pw) {
        pw.println(this.raceToCSVString(aRace));
    }
}

