/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.execution.EvaluableAction;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceOrganization;

public abstract class FiveYearRangeRaceClass<K extends FiveYearRangeRaceClass<K>>
extends RaceClass<K> {
    private static final Class<FiveYearRangeRaceClass> THIS_CLASS = FiveYearRangeRaceClass.class;
    protected static final int AGE_RANGE = 5;
    public final NationalClassGroup<?> group;

    protected FiveYearRangeRaceClass(String name, int startAge, int endAge, String description, RaceOrganization affiliation, NationalClassGroup<?> group) {
        super(name, startAge, endAge, description, affiliation);
        this.group = group;
        this.validateGroup();
    }

    @Override
    public int getAgeRange() {
        return 5;
    }

    @Override
    public RaceClassGroup<?> getGroup() {
        return this.group;
    }

    @Override
    public RaceClass<?> toNationalClass() {
        if (this.isNationalClass()) {
            return this;
        }
        if (!this.isAgeGroupClass()) {
            return null;
        }
        EvaluableAction ageClassConverter = this.getNationalClassConverter();
        if (ageClassConverter == null) {
            return null;
        }
        return (RaceClass)ageClassConverter.evaluate(this);
    }

    protected EvaluableAction getNationalClassConverter() {
        return null;
    }

    protected void validateGroup() {
        if (this.group != null && !this.group.isUnknown()) {
            if (this.group.gender != this.gender) {
                throw new IllegalArgumentException("Invalid national group for " + this.toConstantName() + ": " + this.group + " has different gender");
            }
            if (this.isAgeGroupClass() && !this.group.includesAgeRange(this)) {
                throw new IllegalArgumentException("Invalid national group for " + this.toConstantName() + ": " + this.group + " has disjoint age range");
            }
        }
    }
}

