/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ClassX;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.NationalClassGroup;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW_2000;
import org.ussamasters.aces.racedata.models.NationalClassGroupYOW_2016;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2000;
import org.ussamasters.aces.racedata.models.NationalClassGroup_2016;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceClassGroupType;

public abstract class NationalClassGroupYOW<K extends NationalClassGroupYOW<K>>
extends RaceClassGroup<K> {
    private static final Class<NationalClassGroupYOW> THIS_CLASS = NationalClassGroupYOW.class;
    public static final RaceClassGroupType GROUP_TYPE = RaceClassGroupType.us_masters_yow;
    protected static List<Class<? extends NationalClassGroupYOW<?>>> allNationalGroupYOWClasses;

    public static List<Class<? extends NationalClassGroupYOW<?>>> getAllNationalGroupClasses() {
        if (allNationalGroupYOWClasses == null) {
            ArrayList mySubclasses = new ArrayList();
            for (Class<RaceClassGroup<?>> groupClass : RaceClassGroup.getAllGroupClasses()) {
                if (!ClassX.isProperSubclass(groupClass, THIS_CLASS)) continue;
                mySubclasses.add(groupClass);
            }
            allNationalGroupYOWClasses = Collections.unmodifiableList(mySubclasses);
        }
        return allNationalGroupYOWClasses;
    }

    public static NationalClassGroupYOW<?> getConstant(NationalClassGroup<?> group) {
        if (group instanceof NationalClassGroup_2000) {
            return NationalClassGroupYOW_2000.toGroupYOW((NationalClassGroup_2000)group);
        }
        if (group instanceof NationalClassGroup_2016) {
            return NationalClassGroupYOW_2016.toGroupYOW((NationalClassGroup_2016)group);
        }
        throw new IllegalArgumentException("Unknown national classes group: " + group.toConstantName());
    }

    public static Class<? extends NationalClassGroupYOW<?>> getGroupYOWClass(Class<? extends RaceClassGroup<?>> groupClass) {
        if (groupClass.equals(NationalClassGroup_2000.class)) {
            return NationalClassGroupYOW_2000.class;
        }
        if (groupClass.equals(NationalClassGroup_2016.class)) {
            return NationalClassGroupYOW_2016.class;
        }
        throw new IllegalArgumentException("Unknown national classes group: " + groupClass.getSimpleName());
    }

    protected NationalClassGroupYOW(String name, String description, Gender gender, int startAge, int endAge) {
        super(name, description, gender, startAge, endAge);
    }

    @Override
    public RaceClassGroupType getRaceClassGroupType() {
        return GROUP_TYPE;
    }
}

