/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.ArrayList;
import java.util.List;

public class PolicyID
extends ConstantValueWithDescription<PolicyID> {
    protected static final Class<PolicyID> THIS_CLASS = PolicyID.class;
    public final String category;

    public static PolicyID defineConstant(String name, String category, String description) {
        PolicyID policyID = PolicyID.getConstant(name);
        if (policyID != null) {
            policyID.validateDefinitionConsistency(category, description);
        } else {
            policyID = new PolicyID(name, category, description);
        }
        return policyID;
    }

    public static PolicyID getConstant(int ordinalValue) {
        return PolicyID.getConstant(ordinalValue, THIS_CLASS);
    }

    public static PolicyID getConstant(String name) {
        return PolicyID.getConstant(name, THIS_CLASS);
    }

    public static PolicyID valueOf(String name) {
        return PolicyID.valueOf(THIS_CLASS, name);
    }

    public static List<PolicyID> values() {
        return PolicyID.values(THIS_CLASS);
    }

    public static List<PolicyID> valuesInCategory(String category) {
        ArrayList<PolicyID> policies = new ArrayList<PolicyID>();
        for (PolicyID policyID : PolicyID.values()) {
            if (!policyID.category.equals(category)) continue;
            policies.add(policyID);
        }
        return policies;
    }

    public PolicyID(String name, String category, String description) {
        super(name, description);
        this.category = category;
    }

    protected void validateDefinitionConsistency(String category, String description) {
        if (!this.category.equalsIgnoreCase(category)) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s category to '%s'", this.toConstantName(), category));
        }
        if (!this.description.equalsIgnoreCase(description)) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s description to '%s'", this.toConstantName(), description));
        }
    }
}

