/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.execution.ConstructorAction;
import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.lang.ClassX;
import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.PolicyID;

public class PolicySpecification {
    public PolicyID policyID;
    protected List<ParameterSpecification> parmSpecs;
    protected EvaluableAction constructionAction;

    public PolicySpecification(PolicyID policyID, EvaluableAction constructionAction) {
        this(policyID, null, constructionAction);
    }

    public PolicySpecification(PolicyID policyID, ParameterSpecification[] parmSpecs, EvaluableAction constructionAction) {
        this.policyID = policyID;
        this.constructionAction = constructionAction;
        this.parmSpecs = new ArrayList<ParameterSpecification>();
        if (parmSpecs != null) {
            for (ParameterSpecification parameterSpecification : parmSpecs) {
                this.defineParameter(parameterSpecification);
            }
        }
    }

    public static EvaluableAction createConstructionAction(Class<?> implClass) {
        return ConstructorAction.create(implClass);
    }

    public static EvaluableAction createConstructionAction(Class<?> implClass, Class<?>[] parmTypes) {
        return ConstructorAction.create(implClass, parmTypes);
    }

    public static EvaluableAction createConstructionAction(Class<?> implClass, Class<?>[] parmTypes, Object[] args) {
        return ConstructorAction.create(implClass, parmTypes, args);
    }

    public static EvaluableAction createConstructionAction(String implClassName) {
        Class<?> implClass = ClassX.classForNameOrNull(implClassName);
        return ConstructorAction.create(implClass);
    }

    public static EvaluableAction createConstructionAction(String implClassName, Class<?>[] parmTypes, Object[] args) {
        Class<?> implClass = ClassX.classForNameOrNull(implClassName);
        return ConstructorAction.create(implClass, parmTypes, args);
    }

    protected void copyParametersFrom(PolicySpecification otherSpec) {
        for (ParameterSpecification parameterSpec : otherSpec.parmSpecs) {
            this.defineParameter(parameterSpec.copy());
        }
    }

    public void defineParameter(ParameterSpecification parmSpec) {
        this.parmSpecs.add(parmSpec);
    }

    public String getDescription() {
        return this.policyID.description;
    }

    public Object getParameter(String parmName) {
        return this.getParameter(parmName, null);
    }

    public Object getParameter(String parmName, Object valueIfAbsent) {
        for (ParameterSpecification parmSpec : this.parmSpecs) {
            if (!parmSpec.name.equals(parmName)) continue;
            return parmSpec.value;
        }
        return valueIfAbsent;
    }

    public ParameterSpecification getParameterSpecification(int index) {
        return this.parmSpecs.get(index);
    }

    public ParameterSpecification getParameterSpecification(String parmName) {
        for (ParameterSpecification parmSpec : this.parmSpecs) {
            if (!parmSpec.name.equals(parmName)) continue;
            return parmSpec;
        }
        return null;
    }

    public String getName() {
        return this.policyID.name;
    }

    public int getNumberOfParameters() {
        return this.parmSpecs.size();
    }

    public boolean hasConfigurableParameters() {
        for (ParameterSpecification parmSpec : this.parmSpecs) {
            if (!parmSpec.modifiable) continue;
            return true;
        }
        return false;
    }

    public boolean sameAs(PolicySpecification otherSpec) {
        if (this.policyID != otherSpec.policyID) {
            return false;
        }
        int nParms = this.getNumberOfParameters();
        if (nParms != otherSpec.getNumberOfParameters()) {
            return false;
        }
        for (int i = 0; i < nParms; ++i) {
            if (this.getParameterSpecification(i).sameAs(otherSpec.getParameterSpecification(i))) continue;
            return false;
        }
        return true;
    }

    public void setParameter(String parmName, Object value) {
        for (ParameterSpecification parmSpec : this.parmSpecs) {
            if (!parmSpec.name.equals(parmName)) continue;
            parmSpec.value = value;
            return;
        }
        throw new IllegalArgumentException("No parameter '" + parmName + "' defined in scoring policy " + this.policyID.name);
    }

    public String toString() {
        return String.format("%s<<%s>>", this.getClass().getSimpleName(), this.policyID.name);
    }
}

