/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroupType;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.StandingsCategory;

public abstract class RaceClassGroup<K extends RaceClassGroup<K>>
extends ConstantValueWithDescription<K>
implements RaceDataConstant,
StandingsCategory {
    public final Gender gender;
    public final int startAge;
    public final int endAge;
    private static final Class<RaceClassGroup> THIS_CLASS = RaceClassGroup.class;
    private static boolean staticDataResolved = false;
    private static final List<String> groupClassNames = Arrays.asList("NationalClassGroup_2000", "NationalClassGroup_2016", "NationalClassGroupYOW_2000", "NationalClassGroupYOW_2016", "NationalClassGroupAltM08Split", "FISMastersGroup_2000", "FISMastersGroup_2020");
    private static List<Class<? extends RaceClassGroup<?>>> allGroupClasses;

    public static List<Class<? extends RaceClassGroup<?>>> getAllGroupClasses() {
        if (!staticDataResolved) {
            RaceClassGroup.resolveStaticData();
        }
        return allGroupClasses;
    }

    public static List<? extends StandingsCategory> getStandingsCategories(Class<? extends RaceClassGroup<?>> raceGroupClass) {
        return RaceClassGroup.getConstantValues(raceGroupClass);
    }

    protected static void resolveStaticData() {
        String packagePrefix = THIS_CLASS.getPackage().getName() + ".";
        int nGroupClasses = groupClassNames.size();
        String className = "";
        try {
            ArrayList resolvedList = new ArrayList(nGroupClasses);
            for (String groupClassName : groupClassNames) {
                className = packagePrefix + groupClassName;
                Class<?> groupClass = Class.forName(className);
                resolvedList.add(groupClass);
            }
            allGroupClasses = Collections.unmodifiableList(resolvedList);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Invalid RaceClassGroup reference: " + className);
        }
    }

    protected RaceClassGroup(String name, String description, Gender gender, int startAge, int endAge) {
        super(name, description);
        this.gender = gender;
        this.startAge = startAge;
        this.endAge = endAge;
    }

    public abstract RaceClassGroupType getRaceClassGroupType();

    public boolean includesAge(int age) {
        return age >= this.startAge && age <= this.endAge;
    }

    public boolean includesAgeRange(RaceClass<?> aRaceClass) {
        return aRaceClass.startAge >= this.startAge && aRaceClass.startAge <= this.endAge && aRaceClass.endAge <= this.endAge;
    }

    @Override
    public String toConstantName() {
        return String.format("%s.GROUP_%s", this.getClass().getSimpleName(), this.name);
    }

    public boolean isUnknown() {
        return this == this.unknown();
    }

    public abstract K unknown();
}

