/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.List;
import org.ussamasters.aces.racedata.io.RaceDataIOServices;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceClassType;
import org.ussamasters.aces.racedata.models.SeasonConfiguration;
import org.ussamasters.aces.racedata.models.SeasonIdentifier;

public class RaceClassHelper {
    protected final SeasonIdentifier season;
    protected final SeasonConfiguration seasonConfig;
    protected final RaceClassRegistry raceClassRegistry;

    public RaceClassHelper(SeasonIdentifier season) {
        this.season = season;
        this.seasonConfig = SeasonConfiguration.getSeasonConfig(season);
        this.raceClassRegistry = RaceClassRegistry.current();
    }

    public Class<? extends RaceClass<?>> getNationalClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        return this.seasonConfig.getRaceClassClass(RaceClassType.us_masters);
    }

    public RaceClassType getRaceClassType(Class<? extends RaceClass<?>> raceClassClass) {
        return this.raceClassRegistry.getRaceClassType(raceClassClass);
    }

    public List<? extends RaceClass<?>> getRaceClassValues(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getRaceClassValues(raceClassClass);
    }

    public RaceClass<?> getUnknownClass(Class<? extends RaceClass<?>> raceClassClass, Gender gender) {
        return RaceClass.getUnknownClass(raceClassClass, gender);
    }

    public boolean isDivisionAgeClass(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getDivisionRaceClasses().contains(raceClassClass);
    }

    public boolean isInternationalAgeClass(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getNationalRaceClasses().contains(raceClassClass);
    }

    public boolean isNationalAgeClass(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.getNationalRaceClasses().contains(raceClassClass);
    }

    public RaceClass<?> raceClassForAge(Gender gender, int age, Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.forAge(gender, age, raceClassClass);
    }

    public RaceClass<?> raceClassFromLiteral(String raceClassName, Class<? extends RaceClass<?>> raceClassClass) {
        return RaceClass.resolveName(raceClassName, raceClassClass);
    }

    public Class<? extends RaceClass<?>> raceClassClassFromLiteral(String raceClassLiteral) {
        return SeasonConfiguration.resolveRaceClassLiteral(raceClassLiteral, this.season);
    }

    public String raceClassClassToLiteral(Class<? extends RaceClass<?>> raceClassClass) {
        return RaceDataIOServices.raceClassToLiteral(raceClassClass);
    }

    public RaceClass<?> toNationalClass(RaceClass<?> raceClass) {
        int nationalClassAgeRange;
        Class<?> raceClassClass = raceClass.getClass();
        Class<? extends RaceClass<?>> nationalClassClass = this.seasonConfig.getRaceClassClass(RaceClassType.us_masters);
        if (raceClass.isNationalClass()) {
            return raceClass;
        }
        if (raceClass.isAbilityGroupClass()) {
            return null;
        }
        if (raceClass.isUnknown()) {
            return RaceClass.getUnknownClass(nationalClassClass, raceClass.getGender());
        }
        int raceClassAgeRange = this.raceClassRegistry.getAgeRange(raceClassClass);
        if (raceClassAgeRange != (nationalClassAgeRange = this.raceClassRegistry.getAgeRange(nationalClassClass))) {
            return null;
        }
        RaceClass<?> nationalClass = RaceClass.forAgeRange(raceClass.getGender(), raceClass.startAge, raceClass.endAge, nationalClassClass);
        if (nationalClass == null && raceClass.isInternationalClass()) {
            if (raceClass.startAge == 0) {
                nationalClass = RaceClass.forAge(raceClass.getGender(), raceClass.endAge, nationalClassClass);
            } else if (raceClass.endAge == 999) {
                nationalClass = RaceClass.forAge(raceClass.getGender(), raceClass.startAge, nationalClassClass);
            }
            if (nationalClass == null) {
                throw new RuntimeException("Unable to map " + raceClass + " to " + nationalClassClass);
            }
        }
        return nationalClass;
    }

    public RaceClass<?> toDivisionAgeClass(RaceClass<?> nationalClass, Class<? extends RaceClass<?>> divisionAgeClassClass) {
        if (!nationalClass.isNationalClass()) {
            throw new IllegalArgumentException(String.format("Race class not a national class: %s", nationalClass));
        }
        if (!RaceClass.getDivisionRaceClasses().contains(divisionAgeClassClass)) {
            throw new IllegalArgumentException(String.format("Target class not a division class: %s", divisionAgeClassClass.getSimpleName()));
        }
        return RaceClass.getDivisionAgeClass(nationalClass, divisionAgeClassClass);
    }

    public String toString() {
        return String.format("%s<%s>", this.getClass().getSimpleName(), this.season.name());
    }
}

