/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.HashMap;
import java.util.Map;
import org.ussamasters.aces.racedata.models.NationalClass_2016;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassGroup;
import org.ussamasters.aces.racedata.models.RaceClassGroupType;
import org.ussamasters.aces.racedata.models.RaceClassType;

public class RaceClassRegistry {
    public static final RaceClassRegistry CURRENT = new RaceClassRegistry();
    Map<Class<? extends RaceClass<?>>, Entry> registry = new HashMap();

    public static RaceClassRegistry current() {
        return CURRENT;
    }

    public static void registerDivisionRaceClass(Class<? extends RaceClass<?>> raceClassClass, RaceClassType raceClassType, String description, int ageRange, Class<? extends RaceClass<?>> nationalClassClass, Class<? extends RaceClassGroup<?>> groupClass, RaceClassGroupType groupType) {
        RaceClassRegistry.registerRaceClass(raceClassClass, raceClassType, description, ageRange, nationalClassClass, groupClass, groupType);
    }

    public static void registerNationalRaceClass(Class<? extends RaceClass<?>> raceClassClass, RaceClassType raceClassType, String description, int ageRange, Class<? extends RaceClassGroup<?>> groupClass, RaceClassGroupType groupType) {
        RaceClassRegistry.registerRaceClass(raceClassClass, raceClassType, description, ageRange, raceClassClass, groupClass, groupType);
    }

    public static void registerInternationalRaceClass(Class<? extends RaceClass<?>> raceClassClass, RaceClassType raceClassType, String description, int ageRange, Class<? extends RaceClassGroup<?>> groupClass, RaceClassGroupType groupType) {
        RaceClassRegistry.registerRaceClass(raceClassClass, raceClassType, description, ageRange, null, groupClass, groupType);
    }

    private static void registerRaceClass(Class<? extends RaceClass<?>> raceClassClass, RaceClassType raceClassType, String description, int ageRange, Class<? extends RaceClass<?>> nationalClassClass, Class<? extends RaceClassGroup<?>> groupClass, RaceClassGroupType groupType) {
        if ((raceClassType.isDivisionClass() || raceClassType.isNationalClass()) && (nationalClassClass == null || groupClass == null || groupType == null)) {
            throw new IllegalStateException(String.format("US division/national class %s missing national class/groups specs", raceClassClass.getSimpleName()));
        }
        if (raceClassType.isInternationalClass()) {
            if (nationalClassClass != null) {
                throw new IllegalStateException(String.format("International class %s should not register a national class", raceClassClass.getSimpleName()));
            }
            if (groupClass == null || groupType == null) {
                throw new IllegalStateException(String.format("Internation class %s missing international groups specs", raceClassClass.getSimpleName()));
            }
        }
        Entry entry = new Entry(raceClassClass, raceClassType, description, ageRange, nationalClassClass, groupClass, groupType);
        RaceClassRegistry.CURRENT.registry.put(raceClassClass, entry);
    }

    public int getAgeRange(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        return entry != null ? Integer.valueOf(entry.ageRange) : null;
    }

    public String getDescription(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        return entry != null ? entry.description : null;
    }

    public Class<? extends RaceClass<?>> getNationalClassClass(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        Class<RaceClass<Object>> nationalClassClass = null;
        if (entry != null && (nationalClassClass = entry.nationalClassClass) == null && entry.raceClassType == RaceClassType.fis_masters) {
            nationalClassClass = NationalClass_2016.class;
        }
        return nationalClassClass;
    }

    public RaceClassType getRaceClassType(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        return entry != null ? entry.raceClassType : null;
    }

    public Class<? extends RaceClassGroup<?>> getRaceClassGroupClass(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        return entry != null ? entry.groupClass : null;
    }

    public RaceClassGroupType getRaceClassGroupType(Class<? extends RaceClass<?>> raceClassClass) {
        Entry entry = this.registry.get(raceClassClass);
        return entry != null ? entry.groupType : null;
    }

    static class Entry {
        Class<? extends RaceClass<?>> raceClassClass;
        RaceClassType raceClassType;
        String description;
        int ageRange;
        Class<? extends RaceClass<?>> nationalClassClass;
        Class<? extends RaceClassGroup<?>> groupClass;
        RaceClassGroupType groupType;

        Entry(Class<? extends RaceClass<?>> raceClassClass, RaceClassType raceClassType, String description, int ageRange, Class<? extends RaceClass<?>> nationalClassClass, Class<? extends RaceClassGroup<?>> groupClass, RaceClassGroupType groupType) {
            this.raceClassClass = raceClassClass;
            this.raceClassType = raceClassType;
            this.description = description;
            this.ageRange = ageRange;
            this.nationalClassClass = nationalClassClass;
            this.groupClass = groupClass;
            this.groupType = groupType;
        }

        public String toString() {
            return String.format("RaceClassRegistry.entry<%s, %s, %s, %s yr range; %s, %s, %s, %s, %s>", this.raceClassClass, this.raceClassType, this.description, this.ageRange, this.nationalClassClass, this.groupClass, this.groupType);
        }
    }
}

