/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;

public class RaceDataServices {
    public static RaceDataServices current = new RaceDataServices();

    protected RaceDataServices() {
    }

    public CompetitorResultValue<?> computeRaceResultValue(CompetitorResultValue<?> run1Result, CompetitorResultValue<?> run2Result) {
        if (!run1Result.isFinisher()) {
            return run1Result;
        }
        if (!run2Result.isFinisher()) {
            if (run2Result.isStarter()) {
                return run2Result;
            }
            return UnqualifiedResult.DNF;
        }
        RaceTime firstRunTime = (RaceTime)run1Result;
        RaceTime secondRunTime = (RaceTime)run2Result;
        RaceTime totalTime = firstRunTime.add(secondRunTime);
        return totalTime;
    }

    public CompetitorResultValue<?> raceResultValueFromString(String resultString) {
        if (resultString == null) {
            return null;
        }
        if ((resultString = resultString.trim()).length() == 0) {
            return null;
        }
        UnqualifiedResult noResultValue = UnqualifiedResult.getConstant(resultString);
        if (noResultValue != null) {
            return noResultValue;
        }
        return RaceTime.fromString(resultString);
    }

    public RaceClass<?> raceClassFromString(Class<? extends RaceClass<?>> raceClassClass, String className) {
        return (RaceClass)RaceClass.getResolveNameAction(raceClassClass).evaluate(className);
    }
}

