/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.devx.Assert;
import org.ussamasters.aces.racedata.models.CompetitorResultValue;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceDataServices;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.UnqualifiedResult;

public class RaceEntryResult2Run
extends RaceEntryResult {
    private CompetitorResultValue<?> firstRun;
    private CompetitorResultValue<?> secondRun;

    public RaceEntryResult2Run(int bibNumber, RaceClass<?> raceClass, String lastName, String firstName) {
        super(bibNumber, raceClass, lastName, firstName);
    }

    @Override
    protected void clearTime() {
        super.clearTime();
        this.setFirstRun(UnqualifiedResult.DNS);
        this.setSecondRun(UnqualifiedResult.DNS);
    }

    @Override
    protected int compareByTimeNonFinisher(RacerResult aResult) {
        boolean disabled = true;
        if (disabled) {
            return super.compareByTimeNonFinisher(aResult);
        }
        RaceEntryResult otherResult = (RaceEntryResult)aResult;
        Assert.isTrue(this.isStarter() && !this.isFinisher(), "Invalid non-finisher sort request: " + this.getName() + " - " + this.getResultValue() + " (comparing against " + otherResult.getName() + " - " + aResult.getResultValue() + ")");
        Assert.isTrue(aResult.isStarter() && !aResult.isFinisher(), "Invalid non-finisher sort request: " + otherResult.getName() + " - " + aResult.getResultValue() + " (comparing against " + this.getName() + " - " + this.getResultValue() + ")");
        if (this.getNumberOfRuns() == 1) {
            return 0;
        }
        if (this.hasFirstRunTime() == ((RaceEntryResult2Run)aResult).hasFirstRunTime()) {
            return 0;
        }
        return this.hasFirstRunTime() ? -1 : 1;
    }

    public CompetitorResultValue<?> getFirstRun() {
        return this.firstRun;
    }

    @Override
    public int getNumberOfRuns() {
        return 2;
    }

    public CompetitorResultValue<?> getSecondRun() {
        return this.secondRun;
    }

    protected boolean hasFirstRunTime() {
        return this.firstRun.isFinisher();
    }

    @Override
    public boolean isStarter() {
        return this.firstRun.isStarter() || this.secondRun.isStarter();
    }

    protected void setFirstRun(CompetitorResultValue<?> result) {
        this.firstRun = result == null ? UnqualifiedResult.DNS : result;
    }

    protected void setSecondRun(CompetitorResultValue<?> result) {
        this.secondRun = result == null ? UnqualifiedResult.DNS : result;
    }

    @Override
    public void setTimingData(CompetitorResultValue<?> firstRun, CompetitorResultValue<?> secondRun, CompetitorResultValue<?> total) {
        this.setFirstRun(firstRun);
        this.setSecondRun(secondRun);
        this.setResultValue(total);
        this.clearFinishStatistics();
    }

    @Override
    public void setTimingData(String firstRun, String secondRun, String total) {
        this.setTimingData(RaceDataServices.current.raceResultValueFromString(firstRun), RaceDataServices.current.raceResultValueFromString(secondRun), RaceDataServices.current.raceResultValueFromString(total));
    }

    @Override
    public String toStringResultDetails() {
        return this.getFirstRun().toString() + ", " + this.getSecondRun().toString() + ", " + this.getResultValue().toString();
    }

    public void updateFirstRun(CompetitorResultValue<?> runResultValue) {
        this.setFirstRun(runResultValue);
        this.setResultValue(RaceDataServices.current.computeRaceResultValue(this.getFirstRun(), this.getSecondRun()));
        this.clearFinishStatistics();
    }

    public void updateSecondRun(CompetitorResultValue<?> runResultValue) {
        this.setSecondRun(runResultValue);
        this.setResultValue(RaceDataServices.current.computeRaceResultValue(this.getFirstRun(), this.getSecondRun()));
        this.clearFinishStatistics();
    }

    @Override
    public void validateTimingData() {
        if (this.firstRun == null) {
            Assert.shouldNotBe("Invalid RaceEntryResult (null firstRun): " + this.getBib() + " - " + this.getName());
            this.firstRun = UnqualifiedResult.DNS;
        }
        if (this.secondRun == null) {
            Assert.shouldNotBe("Invalid RaceEntryResult (null secondRun): " + this.getBib() + " - " + this.getName());
            this.secondRun = UnqualifiedResult.DNS;
        }
        if (this.getResultValue() == null) {
            Assert.shouldNotBe("Invalid RaceEntryResult (null result): " + this.getBib() + " - " + this.getName());
            this.setNoResultValue(UnqualifiedResult.DNS);
        }
        if (!this.firstRun.isStarter()) {
            if (this.secondRun.isStarter() && this.getResultValue() == UnqualifiedResult.DNS) {
                if (this.secondRun.isFinisher()) {
                    this.setNoResultValue(UnqualifiedResult.DNF);
                } else {
                    this.setResultValue(this.secondRun);
                }
            }
            return;
        }
        if (!this.firstRun.isFinisher()) {
            this.setResultValue(this.firstRun);
            return;
        }
        if (!this.secondRun.isFinisher()) {
            if (this.secondRun.isStarter()) {
                this.setResultValue(this.secondRun);
            } else if (this.getResultValue() == UnqualifiedResult.DNS) {
                this.setNoResultValue(UnqualifiedResult.DNF);
            }
            return;
        }
        RaceTime firstRunTime = (RaceTime)this.firstRun;
        RaceTime secondRunTime = (RaceTime)this.secondRun;
        RaceTime totalTime = firstRunTime.add(secondRunTime);
        if (this.getResultValue() == UnqualifiedResult.DNS) {
            this.setTime(totalTime);
        } else if (!this.getResultValue().equals(totalTime)) {
            throw new IllegalArgumentException("Incorrect total time " + this.getResultValue() + " in timing data for " + this.getName() + " (should be " + totalTime + ")");
        }
    }
}

