/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.javax.io.ConstantLoader;
import org.ussamasters.javax.io.ConstantSpecifications;

public class RaceLocation
extends ConstantValue<RaceLocation>
implements RaceDataConstant {
    private static final Class<RaceLocation> THIS_CLASS = RaceLocation.class;
    private static final String CONFIG_DIR_REF = "/" + THIS_CLASS.getPackage().getName().replaceAll("\\.", "/").replace("/models", "/configuration");
    public static final RaceLocation UNKNOWN;
    public static final String BUILTIN_CONSTANT_SPECS;
    public static final String SPEC_FIELD_NAME = "name";
    public static final String SPEC_FIELD_FULLNAME = "fullName";
    public static final String SPEC_FIELD_AFFILIATION = "affiliation";
    public static final List<String> CONSTANT_SPEC_FIELDS;
    public final String fullName;
    public final RaceOrganization affiliation;

    public static RaceLocation defineConstant(String name, String fullName, RaceOrganization affiliation) {
        RaceLocation cnst = RaceLocation.getConstant(name);
        if (cnst != null) {
            cnst.validateDefinitionConsistency(fullName, affiliation);
        } else {
            cnst = new RaceLocation(name, fullName, affiliation);
        }
        return cnst;
    }

    public static RaceLocation getConstant(int ordinalValue) {
        return RaceLocation.getConstant(ordinalValue, THIS_CLASS);
    }

    public static RaceLocation getConstant(String name) {
        return RaceLocation.getConstant(name, THIS_CLASS);
    }

    public static List<RaceLocation> values() {
        return RaceLocation.values(THIS_CLASS);
    }

    public static List<RaceLocation> valuesForOrganization(RaceOrganization organization) {
        ArrayList<RaceLocation> locations = new ArrayList<RaceLocation>();
        for (RaceLocation raceLocation : RaceLocation.values()) {
            if (raceLocation.affiliation != organization) continue;
            locations.add(raceLocation);
        }
        return locations;
    }

    public static void loadConstants(String fileRef) {
        ConstantSpecifications specs = ConstantLoader.loadSpecificationsFromFile(fileRef);
        specs.ensureWellFormed(CONSTANT_SPEC_FIELDS);
        for (Map<String, Object> entry : specs.getEntries()) {
            String constantName = (String)entry.get(SPEC_FIELD_NAME);
            String fullName = (String)entry.get(SPEC_FIELD_FULLNAME);
            String affiliation = (String)entry.get(SPEC_FIELD_AFFILIATION);
            RaceLocation.defineConstant(constantName, fullName, RaceOrganization.getConstant(affiliation));
        }
    }

    public RaceLocation(String name, String fullName, RaceOrganization affiliation) {
        super(-1, name);
        this.fullName = fullName;
        this.affiliation = affiliation;
    }

    protected void validateDefinitionConsistency(String fullName, RaceOrganization affiliation) {
        if (!this.fullName.equalsIgnoreCase(fullName)) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s fullName to '%s'", this.toConstantName(), fullName));
        }
        if (this.affiliation != affiliation) {
            throw new IllegalArgumentException(String.format("Conflicting constant definition: cannot change %s affiliation to '%s'", this.toConstantName(), affiliation.name));
        }
    }

    public static void main(String[] args) {
        ConstantLoader.checkSpecificationLoading(BUILTIN_CONSTANT_SPECS);
    }

    static {
        BUILTIN_CONSTANT_SPECS = CONFIG_DIR_REF + "/constants/RaceLocation.yml";
        CONSTANT_SPEC_FIELDS = Collections.unmodifiableList(Arrays.asList(SPEC_FIELD_NAME, SPEC_FIELD_FULLNAME, SPEC_FIELD_AFFILIATION));
        UNKNOWN = new RaceLocation("Unknown", "(unknown location)", RaceOrganization.UNKNOWN);
        RaceLocation.loadConstants(BUILTIN_CONSTANT_SPECS);
    }
}

