/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.Country;
import org.ussamasters.aces.racedata.models.RaceDataConstant;
import org.ussamasters.aces.racedata.models.RaceOrganizationType;
import org.ussamasters.aces.racedata.models.StandingsCategory;

public class RaceOrganization
extends ConstantValueWithDescription<RaceOrganization>
implements RaceDataConstant,
StandingsCategory {
    public static final RaceOrganization UNKNOWN;
    public static final RaceOrganization FAR_WEST;
    public static final RaceOrganization PNSA;
    public static final RaceOrganization NORTHERN;
    public static final RaceOrganization INTERMOUNTAIN;
    public static final RaceOrganization ROCKY;
    public static final RaceOrganization CENTRAL;
    public static final RaceOrganization EASTERN;
    public static final RaceOrganization ALASKA;
    public static final List<RaceOrganization> ussaDivisions;
    public static final RaceOrganization USSA;
    public static final RaceOrganization FIS;
    public static final RaceOrganization CANADA;
    public static final List<RaceOrganization> foreignOrganizations;
    public static final List<RaceOrganization> nationalOrganizations;
    public static final RaceOrganization FOREIGN;
    public static final RaceOrganization TEMP;
    private static final Class<RaceOrganization> THIS_CLASS;
    public final String abbreviation;
    public final RaceOrganizationType organizationType;
    public final Country nationality;

    public static RaceOrganization getConstant(int ordinalValue) {
        return RaceOrganization.getConstant(ordinalValue, THIS_CLASS);
    }

    public static RaceOrganization getConstant(String name) {
        return RaceOrganization.getConstant(name, THIS_CLASS);
    }

    public static List<RaceOrganization> values() {
        return RaceOrganization.values(THIS_CLASS);
    }

    public RaceOrganization(Country nationality) {
        this(nationality.name, RaceOrganizationType.unknown, nationality);
        if (nationality.name.indexOf(32) != -1) {
            throw new IllegalArgumentException("Invalid constant name for national organization: '" + nationality.name + "'");
        }
    }

    public RaceOrganization(String name, RaceOrganizationType organizationType, Country nationality) {
        this(name, nationality.name, organizationType, nationality, nationality.fullName);
    }

    public RaceOrganization(String name, String abbreviation, RaceOrganizationType organizationType, Country nationality, String description) {
        super(name, description);
        this.abbreviation = abbreviation;
        this.organizationType = organizationType;
        this.nationality = nationality;
    }

    @Override
    protected boolean allowSynonyms() {
        return true;
    }

    public boolean isForeignOrganization() {
        return foreignOrganizations.contains(this);
    }

    public boolean isNationalOrganization() {
        return nationalOrganizations.contains(this);
    }

    public boolean isRecognizedOrganization() {
        return this.isUSSADivision() || this.isNationalOrganization();
    }

    public boolean isUSSADivision() {
        return ussaDivisions.contains(this) || this.organizationType == RaceOrganizationType.ussa_division;
    }

    @Override
    public String toString() {
        return this.name;
    }

    protected static void registerSynonyms() {
        String[][] synonymSpecs = new String[][]{{"FW", RaceOrganization.FAR_WEST.name}, {"FWD", RaceOrganization.FAR_WEST.name}, {"FAR", RaceOrganization.FAR_WEST.name}, {"PN", RaceOrganization.PNSA.name}, {"PNS", RaceOrganization.PNSA.name}, {"PNW", RaceOrganization.PNSA.name}, {"N", RaceOrganization.NORTHERN.name}, {"NOR", RaceOrganization.NORTHERN.name}, {"INT", RaceOrganization.INTERMOUNTAIN.name}, {"IM", RaceOrganization.INTERMOUNTAIN.name}, {"IMD", RaceOrganization.INTERMOUNTAIN.name}, {"RM", RaceOrganization.ROCKY.name}, {"RMD", RaceOrganization.ROCKY.name}, {"CEN", RaceOrganization.CENTRAL.name}, {"CN", RaceOrganization.CENTRAL.name}, {"EA", RaceOrganization.EASTERN.name}, {"EAS", RaceOrganization.EASTERN.name}, {"EAD", RaceOrganization.EASTERN.name}, {"AK", RaceOrganization.ALASKA.name}, {"US", RaceOrganization.USSA.name}, {"CA", "CAN"}, {"GDR", "GER"}, {"FR", "FRA"}};
        RaceOrganization.registerSynonyms(synonymSpecs, THIS_CLASS);
    }

    static {
        THIS_CLASS = RaceOrganization.class;
        RaceOrganizationType unknown = RaceOrganizationType.unknown;
        RaceOrganizationType ussa_division = RaceOrganizationType.ussa_division;
        RaceOrganizationType ussa = RaceOrganizationType.ussa;
        RaceOrganizationType fis = RaceOrganizationType.fis;
        UNKNOWN = new RaceOrganization("Unknown", "UNK", unknown, Country.UNKNOWN, "unknown");
        FAR_WEST = new RaceOrganization("FarWest", "FW", ussa_division, Country.USA, "Far West");
        PNSA = new RaceOrganization("PNSA", "PN", ussa_division, Country.USA, "Pacific Northwest");
        NORTHERN = new RaceOrganization("Northern", "N", ussa_division, Country.USA, "Northern");
        INTERMOUNTAIN = new RaceOrganization("Intermountain", "IM", ussa_division, Country.USA, "Intermountain");
        ROCKY = new RaceOrganization("Rocky", "RM", ussa_division, Country.USA, "Rocky Mountain");
        CENTRAL = new RaceOrganization("Central", "CN", ussa_division, Country.USA, "Central");
        EASTERN = new RaceOrganization("Eastern", "EA", ussa_division, Country.USA, "Eastern");
        ALASKA = new RaceOrganization("Alaska", "AK", ussa_division, Country.USA, "Alaska");
        ussaDivisions = Collections.unmodifiableList(Arrays.asList(FAR_WEST, PNSA, NORTHERN, INTERMOUNTAIN, ROCKY, CENTRAL, EASTERN, ALASKA));
        USSA = new RaceOrganization("USSA", "US", ussa, Country.USA, "USSA");
        ArrayList<RaceOrganization> foreignOrgsList = new ArrayList<RaceOrganization>();
        ArrayList<RaceOrganization> nationalOrgsList = new ArrayList<RaceOrganization>();
        nationalOrgsList.add(USSA);
        for (Country country : Country.values()) {
            if (country == Country.UNKNOWN) continue;
            RaceOrganization countryOrg = new RaceOrganization(country);
            nationalOrgsList.add(countryOrg);
            if (country == Country.USA) continue;
            foreignOrgsList.add(countryOrg);
        }
        nationalOrgsList.addAll(foreignOrgsList);
        foreignOrganizations = Collections.unmodifiableList(foreignOrgsList);
        nationalOrganizations = Collections.unmodifiableList(nationalOrgsList);
        FIS = new RaceOrganization("FIS", "FIS", fis, Country.UNKNOWN, "FIS Masters");
        CANADA = RaceOrganization.getConstant(Country.CANADA.name);
        FOREIGN = new RaceOrganization("Foreign", "X", unknown, Country.UNKNOWN, "Foreign");
        TEMP = new RaceOrganization("Temp", "T", unknown, Country.UNKNOWN, "USSA temp license");
        RaceOrganization.registerSynonyms();
    }
}

