/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceDescriptor;
import org.ussamasters.aces.racedata.models.RaceSummaryStatistics;
import org.ussamasters.aces.racedata.models.RacerResult;

public class RaceResult
extends RaceDescriptor
implements Cloneable {
    public static final int UNKNOWN_F_VALUE = -1;
    private List<RacerResult> racerResultsList;
    private RaceSummaryStatistics summaryStatistics;
    private int fValue;

    public RaceResult(RaceDescriptor aRaceDescriptor, List<RacerResult> resultsList) {
        super(aRaceDescriptor);
        this.racerResultsList = resultsList;
        this.fValue = -1;
        this.summaryStatistics = null;
    }

    public RaceResult(RaceDescriptor aRaceDescriptor, List<RacerResult> resultsList, int nCompetitors, int nFinishers, int fValue) {
        super(aRaceDescriptor);
        this.racerResultsList = resultsList;
        this.fValue = fValue;
        this.computeRaceStatistics();
        if (this.getNumberOfCompetitors() != nCompetitors) {
            throw new IllegalArgumentException("Inconsistent number of competitors: " + nCompetitors + " specified but " + this.getNumberOfCompetitors() + " computed from results");
        }
        if (this.getNumberOfFinishers() != nFinishers) {
            throw new IllegalArgumentException("Inconsistent number of finishers: " + nFinishers + " specified but " + this.getNumberOfFinishers() + " computed from results");
        }
    }

    protected RaceResult(RaceDescriptor aRaceDescriptor, List<RacerResult> resultsList, RaceSummaryStatistics summaryStatistics, int fValue) {
        super(aRaceDescriptor);
        this.racerResultsList = resultsList;
        this.fValue = fValue;
        this.summaryStatistics = summaryStatistics;
    }

    public void clearFinishStatistics() {
        for (RacerResult racerResult : this.racerResultsList) {
            racerResult.clearFinishStatistics();
        }
    }

    public void clearRaceStatistics() {
        this.summaryStatistics.clear();
    }

    public Object clone() {
        RaceResult copy = new RaceResult(this, this.copyRacerResults(), null, this.fValue);
        if (this.summaryStatistics != null) {
            copy.summaryStatistics = this.summaryStatistics.copy();
        }
        return copy;
    }

    public List<RacerResult> copyRacerResults() {
        return new ArrayList<RacerResult>(this.racerResultsList);
    }

    @Override
    public RaceResult copy() {
        return (RaceResult)this.clone();
    }

    protected void computeRaceStatistics() {
        this.summaryStatistics = new RaceSummaryStatistics();
        this.summaryStatistics.computeStatistics(this);
    }

    public int getFValue() {
        return this.fValue;
    }

    public int getNumberOfCompetitors() {
        return this.summaryStatistics.getNumberOfCompetitors();
    }

    public int getNumberOfCompetitors(Gender gender) {
        return this.summaryStatistics.getNumberOfCompetitors(gender);
    }

    public int getNumberOfFinishers() {
        return this.summaryStatistics.getNumberOfQualifiers();
    }

    public int getNumberOfFinishers(Gender gender) {
        return this.summaryStatistics.getNumberOfQualifiers(gender);
    }

    public List<RacerResult> getRacerResults() {
        return Collections.unmodifiableList(this.racerResultsList);
    }

    public RaceSummaryStatistics getSummaryStatistics() {
        return this.summaryStatistics;
    }

    public void installStandings(int fValue, List<RacerResult> reorderedResults) {
        this.setFValue(fValue);
        this.racerResultsList = reorderedResults;
        if (this.summaryStatistics == null) {
            this.computeRaceStatistics();
        }
    }

    public int removeNonStarters() {
        int nRacersTotal = this.racerResultsList.size();
        this.racerResultsList.removeIf(racerResult -> !racerResult.isStarter());
        int nStarters = this.racerResultsList.size();
        int numDNS = nRacersTotal - nStarters;
        return numDNS;
    }

    public void recomputeRaceStatistics() {
        this.computeRaceStatistics();
    }

    public void setFValue(int fValue) {
        this.fValue = fValue;
    }

    @Override
    public String toString() {
        return String.format("%s {%s, %s, %s, %s competitors}", this.getClass().getSimpleName(), this.raceId.toReferenceString(), this.getRaceClassClass().getSimpleName(), this.getCourseArrangement().name(), this.racerResultsList.size());
    }
}

