/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.HashSet;
import java.util.Set;
import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.StandingsCategory;

public class SeriesRacerSummary {
    private Racer racer;
    private int numStarts;
    private int numFinishes;
    private Set<StandingsCategory> competitionCategories;

    public SeriesRacerSummary(Racer racer) {
        this.racer = racer;
        this.clearResults();
    }

    public void clearResults() {
        this.numStarts = 0;
        this.numFinishes = 0;
        this.competitionCategories = new HashSet<StandingsCategory>();
    }

    public String getBib() {
        return this.racer.getBib();
    }

    public int getBibNumber() {
        return this.racer.getBibNumber();
    }

    public Gender getGender() {
        return this.racer.getGender();
    }

    public String getName() {
        return this.racer.getName();
    }

    public int getNumberOfFinishes() {
        return this.numFinishes;
    }

    public int getNumberOfStarts() {
        return this.numStarts;
    }

    public Racer getRacer() {
        return this.racer;
    }

    public boolean hasStartsInAbilityGroupClass() {
        for (StandingsCategory category : this.competitionCategories) {
            if (!(category instanceof RaceClass) || !((RaceClass)category).isAbilityGroupClass()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStartsInMultipleCategories() {
        return this.competitionCategories.size() > 1;
    }

    public void updateSummaryStatistics(RaceStartResult raceStartResult, StandingsCategory category) {
        ++this.numStarts;
        if (raceStartResult.isFinisher()) {
            ++this.numFinishes;
        }
        this.competitionCategories.add(category);
    }

    public String toString() {
        return String.format("%s<%s, %s: %s starts, %s finishes>", this.getClass().getSimpleName(), this.racer.getBib(), this.racer.getNameFirstLast(), this.numStarts, this.numFinishes);
    }
}

