/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import com.glaivestone.javax.lang.ConstantValue;

public class StandingsSummaryData {
    protected static final int UNKNOWN_COUNT = -1;
    protected Object type;
    protected Object category;
    protected int nSources;
    protected int total;

    public StandingsSummaryData(Object type, Object category) {
        this(type, category, -1, -1);
    }

    public StandingsSummaryData(Object type, Object category, int nSources) {
        this(type, category, nSources, -1);
    }

    public StandingsSummaryData(Object type, Object category, int nSources, int total) {
        this.type = type;
        this.category = category;
        this.nSources = nSources;
        this.total = total;
    }

    protected int computeAverage(int count, int divisor) {
        return Math.round((float)count / (float)divisor);
    }

    public void clearTotal() {
        this.total = 0;
    }

    public StandingsSummaryData copy() {
        return new StandingsSummaryData(this.type, this.category, this.nSources, this.total);
    }

    public int getAverage() {
        return this.computeAverage(this.total, this.nSources);
    }

    public Object getCategory() {
        return this.category;
    }

    public int getNumberOfDataSources() {
        return this.nSources;
    }

    public int getTotal() {
        return this.total;
    }

    public void incrementNumberOfDataSources() {
        ++this.nSources;
    }

    public void incrementTotal() {
        ++this.total;
    }

    public void incrementTotal(int count) {
        this.total += count;
    }

    public String toString() {
        String categoryDescription = this.category instanceof ConstantValue ? ((ConstantValue)this.category).toConstantName() : "" + this.category;
        return String.format("%s<%s, %s>", this.getClass().getSimpleName(), categoryDescription, "" + this.total);
    }

    public void setNumberOfDataSources(int count) {
        this.nSources = count;
    }
}

