/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.models.WorldCupPointsType;

public class WorldCupPoints30
extends WorldCupPoints<WorldCupPoints30> {
    private static final Class<WorldCupPoints30> THIS_CLASS = WorldCupPoints30.class;
    public static final WorldCupPointsType SCORING_TYPE = WorldCupPointsType.worldCupPoints30;
    public static final WorldCupPoints30 ZERO;
    public static final WorldCupPointsFactory FACTORY;
    protected static final int maxPointsForPredefinedValue;
    protected static final WorldCupPoints30[] predefinedValues;
    protected static final int nPointScoringPositions;
    protected static final WorldCupPoints30[] finishPositionPointScores;

    public static WorldCupPoints30 forPoints(int points) {
        if (points < 0) {
            throw new IllegalArgumentException("Invalid value for World Cup points: " + points);
        }
        return points <= maxPointsForPredefinedValue ? predefinedValues[points] : new WorldCupPoints30(points);
    }

    public static WorldCupPoints30 forPosition(int position) {
        if (position <= 0) {
            throw new IllegalArgumentException("Invalid position for World Cup points: " + position);
        }
        return position > nPointScoringPositions ? ZERO : finishPositionPointScores[position - 1];
    }

    protected WorldCupPoints30(int points) {
        super(points);
    }

    @Override
    public WorldCupPoints30 add(WorldCupPoints30 otherPoints) {
        if (otherPoints == ZERO) {
            return this;
        }
        if (this == ZERO) {
            return otherPoints;
        }
        return WorldCupPoints30.forPoints(this.intValue() + otherPoints.intValue());
    }

    public String toString() {
        return this.getClass().getName() + (this == ZERO ? ".ZERO" : "{" + this.points + "}");
    }

    static {
        FACTORY = new WorldCupPointsFactory(){

            @Override
            public WorldCupPointsType scoringType() {
                return SCORING_TYPE;
            }

            @Override
            public WorldCupPoints<?> forPoints(int points) {
                return WorldCupPoints30.forPoints(points);
            }

            @Override
            public WorldCupPoints<?> forPosition(int position) {
                return WorldCupPoints30.forPosition(position);
            }

            @Override
            public WorldCupPoints<?> zero() {
                return ZERO;
            }
        };
        int[] newWorldCupPointsSpec = new int[]{100, 80, 60, 50, 45, 40, 36, 32, 29, 26, 24, 22, 20, 18, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1};
        ZERO = new WorldCupPoints30(0);
        maxPointsForPredefinedValue = newWorldCupPointsSpec[0];
        predefinedValues = new WorldCupPoints30[maxPointsForPredefinedValue + 1];
        WorldCupPoints30.predefinedValues[0] = ZERO;
        for (int points = 1; points <= maxPointsForPredefinedValue; ++points) {
            WorldCupPoints30.predefinedValues[points] = new WorldCupPoints30(points);
        }
        nPointScoringPositions = newWorldCupPointsSpec.length;
        finishPositionPointScores = new WorldCupPoints30[nPointScoringPositions];
        for (int i = 0; i < nPointScoringPositions; ++i) {
            int points = newWorldCupPointsSpec[i];
            WorldCupPoints30.finishPositionPointScores[i] = predefinedValues[points];
        }
        WorldCupPoints30.registerPointsFactory(THIS_CLASS, SCORING_TYPE, FACTORY);
    }
}

