/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.models;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum WorldCupPointsType {
    worldCupPoints15("WorldCupPoints15", 15, "Top 15 finishers score (25, 20, 15, ...)"),
    worldCupPoints30("WorldCupPoints30", 30, "Top 30 finishers score (100, 80, 60, 50, ...)");

    public static final WorldCupPointsType DEFAULT;
    public static final List<WorldCupPointsType> SUPPORTED_TYPES;
    private static final Map<String, WorldCupPointsType> formulasRegistry;
    public final String formulaId;
    public final int nScoringPositions;
    public final String description;

    private static Map<String, WorldCupPointsType> constructFormalasRegistry() {
        HashMap<String, WorldCupPointsType> registry = new HashMap<String, WorldCupPointsType>();
        registry.put(WorldCupPointsType.worldCupPoints15.formulaId, worldCupPoints15);
        registry.put(WorldCupPointsType.worldCupPoints30.formulaId, worldCupPoints30);
        return registry;
    }

    public static WorldCupPointsType forFormula(String scoringType) {
        return formulasRegistry.get(scoringType);
    }

    private WorldCupPointsType(String formulaId, int nScoringPositions, String description) {
        this.formulaId = formulaId;
        this.nScoringPositions = nScoringPositions;
        this.description = description;
    }

    static {
        DEFAULT = worldCupPoints15;
        SUPPORTED_TYPES = Collections.unmodifiableList(Arrays.asList(worldCupPoints15, worldCupPoints30));
        formulasRegistry = WorldCupPointsType.constructFormalasRegistry();
    }
}

