/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import com.glaivestone.javax.io.FileType;
import com.glaivestone.toolbox.settings.SettingsHolder;
import com.glaivestone.toolbox.settings.SettingsSection;
import com.glaivestone.toolbox.settings.StandardSettingsSection;
import java.io.File;
import org.ussamasters.aces.racedata.io.RaceDataIOConstants;

public class RaceDataReportOptions
extends SettingsHolder {
    public static final String NAME = "Report";
    public static final String DEFAULT_RACE_SCORING_STYLESHEET_PREFIX = "racescoring";
    public static final String DEFAULT_SERIES_SCORING_STYLESHEET_PREFIX = "seriesscoring";
    private static final String PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS = "includeRacerAffiliationInReports";
    private static final String PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS = "includeRacePointsInTextReports";
    private static final String PROPERTY_SAVE_REPORT_SCORING_DATA = "saveReportScoringData";
    private static final String PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS = "saveReportFO";
    protected File scoringDataDirectory;
    protected File[] transformationStyleSheetsDirectories;

    public RaceDataReportOptions(SettingsSection settings) {
        super(settings != null ? settings : new StandardSettingsSection(NAME));
    }

    public static RaceDataReportOptions defaultSettings() {
        return new RaceDataReportOptions(null);
    }

    protected String composeTransformationStylesheetName(String prefix, FileType reportType) {
        String baseFileName = prefix + "-" + reportType.extension;
        return RaceDataIOConstants.FILE_TYPE_XSL.composeFileName(baseFileName);
    }

    public boolean getIncludeRacerAffiliationInReports() {
        return this.getSettings().getBooleanValue(PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS, false);
    }

    public boolean getIncludeRacePointsInTextReports() {
        return this.getSettings().getBooleanValue(PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS, true);
    }

    public boolean getSaveReportScoringData() {
        return this.getSettings().getBooleanValue(PROPERTY_SAVE_REPORT_SCORING_DATA, false);
    }

    public boolean getSaveReportFormattingSpecifications() {
        return this.getSettings().getBooleanValue(PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS, false);
    }

    public File getScoringDataDirectory() {
        return this.scoringDataDirectory;
    }

    public File getRaceReportTransformation(FileType reportType) {
        return this.getReportTransformation(this.composeTransformationStylesheetName(this.raceScoringStylesheetPrefix(), reportType));
    }

    protected File getReportTransformation(String fileName) {
        for (int i = 0; i < this.transformationStyleSheetsDirectories.length; ++i) {
            File reportTransform = new File(this.transformationStyleSheetsDirectories[i], fileName);
            if (!reportTransform.exists()) continue;
            return reportTransform;
        }
        throw new IllegalStateException("No report transformation stylesheet found: " + fileName);
    }

    public File getSeriesReportTransformation(FileType reportType) {
        return this.getReportTransformation(this.composeTransformationStylesheetName(this.seriesScoringStylePrefix(), reportType));
    }

    public String raceScoringStylesheetPrefix() {
        return DEFAULT_RACE_SCORING_STYLESHEET_PREFIX;
    }

    public String seriesScoringStylePrefix() {
        return DEFAULT_SERIES_SCORING_STYLESHEET_PREFIX;
    }

    public void setIncludeRacerAffiliationInReports(boolean aValue) {
        this.getSettings().setBooleanValue(PROPERTY_INCLUDE_RACER_AFFILIATION_IN_REPORTS, aValue);
    }

    public void setIncludeRacePointsInTextReports(boolean aValue) {
        this.getSettings().setBooleanValue(PROPERTY_INCLUDE_RACE_POINTS_IN_TEXT_REPORTS, aValue);
    }

    public void setSaveReportScoringData(boolean aValue) {
        this.getSettings().setBooleanValue(PROPERTY_SAVE_REPORT_SCORING_DATA, aValue);
    }

    public void setSaveReportFormattingSpecifications(boolean aValue) {
        this.getSettings().setBooleanValue(PROPERTY_SAVE_REPORT_FORMATTING_OBJECTS, aValue);
    }

    public void setScoringDataDirectory(File aDirectory) {
        this.scoringDataDirectory = aDirectory;
    }

    public void setTransformationStylesheetSearchPath(File[] directoryList) {
        this.transformationStyleSheetsDirectories = directoryList;
    }
}

