/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import org.jdom2.Content;
import org.jdom2.Element;
import org.ussamasters.aces.racedata.models.NamedRacerResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult;
import org.ussamasters.aces.racedata.models.RaceEntryResult2Run;
import org.ussamasters.aces.racedata.models.RaceResult;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.RacerList;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.reports.RaceScoring;
import org.ussamasters.aces.racedata.reports.ScoringData;
import org.ussamasters.aces.racedata.reports.ScoringDataDocument;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.RaceStandings;
import org.ussamasters.aces.racedata.scoring.Standings;

public class RaceScoringDocument
extends ScoringDataDocument {
    public static final String ROOT_NODE_NAME = "ACES_RaceScoring";
    public static final String DTD_URI = "http://www.glaivestone.com/aces/schemas/2002/racescoring.dtd";
    public static final String SCHEMA_URI = "http://www.glaivestone.com/aces/schemas/2002/racescoring.xsd";
    public static final String EN_SEASON_END_YEAR = "season";
    public static final String EN_FVALUE = "fValue";
    public static final String EN_RUN1 = "run1";
    public static final String EN_RUN2 = "run2";
    public static final String EN_RESULT = "result";
    public static final String EN_RESULT_RACE_POINTS = "racePoints";
    public static final String EN_RESULT_WC_POINTS = "wcPoints";
    protected RaceScoring raceScoring;
    protected RacerList racerList;
    protected RaceResult raceResult;
    protected int nRuns;

    public RaceScoringDocument(RaceScoring raceScoring, RacerList racerList) {
        this.raceScoring = raceScoring;
        this.racerList = racerList;
        this.raceResult = this.raceScoring.getRaceResult();
        this.nRuns = this.raceResult.getNumberOfRuns();
    }

    @Override
    protected void buildDocumentContent() {
        this.getRootElement().addContent((Content)this.createEventSection());
        this.getRootElement().addContent((Content)this.createScoringSection());
        this.setReportPolicy((Standings)this.raceScoring.getFirstStandings());
        this.getRootElement().addContent((Content)this.createCompetitorsSection());
        for (RaceStandings raceStandings : this.raceScoring.getStandings()) {
            this.setReportPolicy(raceStandings);
            this.getRootElement().addContent((Content)this.createStandingsSection(raceStandings));
        }
        this.getRootElement().addContent((Content)this.createAuxInfoSection());
    }

    protected Element createEventSection() {
        return this.createRaceElement(this.raceResult);
    }

    protected Element createCompetitorElement(RaceEntryResult racerResult) {
        Element anElement = super.createCompetitorElement(racerResult, racerResult.getRaceClass());
        anElement.setAttribute("status", this.toRacerStatus(racerResult));
        if (this.nRuns == 2) {
            RaceEntryResult2Run rr2 = (RaceEntryResult2Run)racerResult;
            this.addTextElement(EN_RUN1, "" + rr2.getFirstRun(), anElement);
            this.addTextElement(EN_RUN2, "" + rr2.getSecondRun(), anElement);
        }
        if (racerResult.isStarter()) {
            this.addTextElement(EN_RESULT, "" + racerResult.getResultValue(), anElement);
        }
        return anElement;
    }

    @Override
    protected Element createCompetitorResultElement(NamedRacerResult racerResult, Object category) {
        Racer theRacer;
        Element anElement = super.createCompetitorResultElement(racerResult, category);
        if (this.isAbilityClassCategory(category) && this.racerList != null && (theRacer = this.racerList.getRacer(racerResult.getBibNumber())) != null) {
            anElement.setAttribute("ageClass", theRacer.getAgeClass().name);
        }
        if (this.isQualified(racerResult)) {
            anElement.addContent((Content)this.createCompetitorPositionElement(racerResult));
            this.addTextElement(EN_RESULT_RACE_POINTS, racerResult.getRacePoints().toScoringValueString(), anElement);
            if (racerResult.getPoints().intValue() > 0) {
                this.addTextElement(EN_RESULT_WC_POINTS, racerResult.getPoints().toScoringValueString(), anElement);
            }
        }
        return anElement;
    }

    protected Element createCompetitorsSection() {
        Element aSection = new Element("competitors");
        for (RacerResult rr : this.raceResult.getRacerResults()) {
            RaceEntryResult aRacerResult = (RaceEntryResult)rr;
            if (!this.shouldWriteRacerEntry(aRacerResult)) continue;
            aSection.addContent((Content)this.createCompetitorElement(aRacerResult));
        }
        return aSection;
    }

    protected Element createScoringSection() {
        Element aSection = new Element("scoring");
        this.addTextElement(EN_SEASON_END_YEAR, Integer.toString(this.raceResult.getDate().getSeasonEndYear()), aSection);
        this.addTextElement(EN_FVALUE, Integer.toString(this.raceResult.getFValue()), aSection);
        return aSection;
    }

    @Override
    protected ScoringData<?> getScoringData() {
        return this.raceScoring;
    }

    @Override
    protected void initDocument() {
        this.initDocument(ROOT_NODE_NAME, DTD_URI, SCHEMA_URI);
    }

    @Override
    protected boolean isQualified(NamedRacerResult racerResult) {
        return racerResult.isFinisher();
    }

    @Override
    protected boolean shouldWriteCategoryResults(CategoryResultsList<?> categoryResultsList) {
        return super.shouldWriteCategoryResults(categoryResultsList) && ((RaceEntryResult)categoryResultsList.get(0)).isStarter();
    }

    @Override
    protected boolean shouldWriteRacerEntry(NamedRacerResult racerResult) {
        return racerResult.isStarter();
    }

    protected String toRacerStatus(RaceEntryResult racerResult) {
        if (this.isQualified(racerResult)) {
            return "QLF";
        }
        if (racerResult.isStarter()) {
            return "DNQ";
        }
        return "DNS";
    }
}

