/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.reports;

import java.util.HashMap;
import java.util.Map;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.ScoringValue;
import org.ussamasters.aces.racedata.models.SiseCupPoints;

public abstract class SeriesScoringValueRenderer {
    public static final SeriesScoringValueRenderer TIME_RENDERER;
    public static final SeriesScoringValueRenderer POINTS_RENDERER;
    public static final SeriesScoringValueRenderer RACE_POINTS_RENDERER;
    public static final SeriesScoringValueRenderer DIVISIONS_CUP_POINTS_RENDERER;
    public static final SeriesScoringValueRenderer SISE_CUP_POINTS_RENDERER;
    protected static final String NO_SCORE_STRING = "-";
    protected static final String IGNORED_SCORE_STRING = "*";
    private static Map<ScoringElement, SeriesScoringValueRenderer> elementAccessorMap;
    private ScoringElement scoringElement;

    public SeriesScoringValueRenderer(ScoringElement scoringElement) {
        this.scoringElement = scoringElement;
    }

    public String composeRacerScoreEntry(RaceSeriesResult racerResult) {
        return racerResult.isQualified() ? this.scoringValueString(racerResult) : NO_SCORE_STRING;
    }

    public String composeRaceStartPositionScoreEntry(RaceStartResult racerResult) {
        if (racerResult == null) {
            return null;
        }
        if (!racerResult.isFinisher()) {
            return "" + racerResult.getNoResultValue();
        }
        return this.composeRaceFinishPositionScoreEntry(racerResult);
    }

    protected String composeRaceFinishPositionScoreEntry(RaceStartResult racerResult) {
        return this.formatRaceStartResult(racerResult.getPositionString(), this.getScore(racerResult));
    }

    protected String formatRaceStartResult(String positionString, ScoringValue<?> score) {
        return this.formatRaceStartResult(positionString, score.toScoringValueString());
    }

    protected String formatRaceStartResult(String positionString, String score) {
        return positionString + "(" + score + ")";
    }

    protected abstract ScoringValue<?> getScore(RacerResult var1);

    public ScoringElement getScoringElement() {
        return this.scoringElement;
    }

    protected String scoringValueString(RacerResult racerResult) {
        return this.getScore(racerResult).toScoringValueString();
    }

    public String toRaceStartScoreString(RaceStartResult racerResult) {
        return racerResult.isFinisher() ? this.scoringValueString(racerResult) : "" + racerResult.getNoResultValue();
    }

    public String toSeriesScoreString(RaceSeriesResult seriesResult) {
        return this.scoringValueString(seriesResult);
    }

    public static SeriesScoringValueRenderer forScoringElement(ScoringElement scoringElement) {
        if (scoringElement == ScoringElement.ADJUSTED_TIME) {
            return SeriesScoringValueRenderer.forScoringElement(ScoringElement.TIME);
        }
        return elementAccessorMap.get(scoringElement);
    }

    protected static void registerAccessor(ScoringElement scoringElement, SeriesScoringValueRenderer aRenderer) {
        elementAccessorMap.put(scoringElement, aRenderer);
    }

    static {
        elementAccessorMap = new HashMap<ScoringElement, SeriesScoringValueRenderer>();
        ScoringElement scoringElement = ScoringElement.TIME;
        SeriesScoringValueRenderer aRenderer = new SeriesScoringValueRenderer(scoringElement){

            @Override
            protected ScoringValue<?> getScore(RacerResult racerResult) {
                return racerResult.getResultValue();
            }
        };
        SeriesScoringValueRenderer.registerAccessor(scoringElement, aRenderer);
        TIME_RENDERER = aRenderer;
        scoringElement = ScoringElement.POINTS;
        aRenderer = new SeriesScoringValueRenderer(scoringElement){

            @Override
            public String composeRacerScoreEntry(RaceSeriesResult racerResult) {
                return this.formatPoints(racerResult.getPoints().intValue());
            }

            @Override
            protected String composeRaceFinishPositionScoreEntry(RaceStartResult racerResult) {
                int position = racerResult.getPosition();
                int points = racerResult.getPoints().intValue();
                if (position > 0) {
                    return this.formatRaceStartResult(racerResult.getPositionString(), this.formatPoints(points));
                }
                if (position == -999) {
                    return this.formatRaceStartResult("OPN", this.formatPoints(points));
                }
                return this.formatRaceStartResult("X" + RaceStartResult.composePositionString(position, racerResult.isTied()), SeriesScoringValueRenderer.IGNORED_SCORE_STRING);
            }

            protected String formatPoints(int points) {
                return points > 0 ? "" + points : SeriesScoringValueRenderer.NO_SCORE_STRING;
            }

            @Override
            protected ScoringValue<?> getScore(RacerResult racerResult) {
                return racerResult.getPoints();
            }

            @Override
            public String toSeriesScoreString(RaceSeriesResult seriesResult) {
                return this.formatPoints(seriesResult.getPoints().intValue());
            }
        };
        SeriesScoringValueRenderer.registerAccessor(scoringElement, aRenderer);
        POINTS_RENDERER = aRenderer;
        scoringElement = ScoringElement.RACE_POINTS;
        aRenderer = new SeriesScoringValueRenderer(scoringElement){

            @Override
            protected ScoringValue<?> getScore(RacerResult racerResult) {
                return racerResult.getRacePoints();
            }
        };
        SeriesScoringValueRenderer.registerAccessor(scoringElement, aRenderer);
        RACE_POINTS_RENDERER = aRenderer;
        scoringElement = ScoringElement.DIVISIONS_CUP_POINTS;
        aRenderer = new SeriesScoringValueRenderer(scoringElement){

            @Override
            protected ScoringValue<?> getScore(RacerResult racerResult) {
                if (racerResult instanceof RaceStartResult) {
                    return ((RaceStartResult)racerResult).getDivisionsCupPoints();
                }
                if (racerResult instanceof RaceSeriesResult) {
                    return ((RaceSeriesResult)racerResult).getDivisionsCupPoints();
                }
                throw new IllegalArgumentException("No Divisions Cup points in result " + racerResult);
            }
        };
        SeriesScoringValueRenderer.registerAccessor(scoringElement, aRenderer);
        DIVISIONS_CUP_POINTS_RENDERER = aRenderer;
        scoringElement = ScoringElement.SISE_CUP_POINTS;
        aRenderer = new SeriesScoringValueRenderer(scoringElement){

            @Override
            protected ScoringValue<?> getScore(RacerResult racerResult) {
                if (racerResult instanceof RaceStartResult) {
                    if (((RaceStartResult)racerResult).isFinisher()) {
                        return SiseCupPoints.forPosition(((RaceStartResult)racerResult).getPosition());
                    }
                    return null;
                }
                if (racerResult instanceof RaceSeriesResult) {
                    return ((RaceSeriesResult)racerResult).getSiseCupPoints();
                }
                throw new IllegalArgumentException("No Sise Cup points in result " + racerResult);
            }
        };
        SeriesScoringValueRenderer.registerAccessor(scoringElement, aRenderer);
        SISE_CUP_POINTS_RENDERER = null;
    }
}

