/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import org.ussamasters.aces.racedata.models.Gender;
import org.ussamasters.aces.racedata.models.ParameterSpecification;
import org.ussamasters.aces.racedata.models.ParameterType;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RacePoints;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.Racer;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.WorldCupPoints;
import org.ussamasters.aces.racedata.models.WorldCupPoints15;
import org.ussamasters.aces.racedata.models.WorldCupPointsFactory;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.StandardSeriesScoringPolicy;

public class AgeClassAbilityBonusScoringPolicy
extends StandardSeriesScoringPolicy {
    public static final WorldCupPointsFactory DEFAULT_POINTS_FACTORY = WorldCupPoints15.FACTORY;
    public static final WorldCupPoints<?> DEFAULT_AGE_CLASS_ABILITY_SCORE = DEFAULT_POINTS_FACTORY.forPosition(2);
    public static final boolean DEFAULT_INCLUDE_ABILITY_CLASSES = false;
    public static final String PARM_BONUS_VALUE = "bonusValue";
    public static final String PARM_INCLUDE_ABILITY_CLASSES = "includeAbilityClasses";
    protected static final RaceStartResult DEFAULT_AGE_CLASS_ABILITY_SCORE_RESULT = AgeClassAbilityBonusScoringPolicy.constructAgeClassAbilityBonusResult(DEFAULT_AGE_CLASS_ABILITY_SCORE);
    protected WorldCupPointsFactory pointsFactory;
    protected RaceStartResult ageClassAbilityBonusResult;
    protected boolean includeAbilityClasses;
    protected RaceClass<?> mensAbilityClass;
    protected RaceClass<?> womensAbilityClass;

    protected static RaceStartResult constructAgeClassAbilityBonusResult(WorldCupPoints<?> points) {
        return new RaceStartResult(RaceTime.ZERO, -999, points, RacePoints.ZERO);
    }

    public static ParameterSpecification createBonusValueParmSpec(int bonusValue) {
        return new ParameterSpecification(PARM_BONUS_VALUE, "Bonus points", "Points awarded in age class for an ability class finish", ParameterType.INTEGER, true, new Integer(bonusValue));
    }

    public static ParameterSpecification createIncludeAbilityClassesParmSpec(boolean includeAbilityClass) {
        return new ParameterSpecification(PARM_INCLUDE_ABILITY_CLASSES, "include ability classes in standings", "Include ability class standings in results report", ParameterType.BOOLEAN, true, new Boolean(includeAbilityClass));
    }

    public static SeriesStandingsScoringPolicy forElement(ScoringElement scoringElement) {
        return new AgeClassAbilityBonusScoringPolicy(scoringElement, DEFAULT_POINTS_FACTORY, DEFAULT_AGE_CLASS_ABILITY_SCORE, false, false, false);
    }

    public AgeClassAbilityBonusScoringPolicy() {
        this(DEFAULT_POINTS_FACTORY, DEFAULT_AGE_CLASS_ABILITY_SCORE, false);
    }

    public AgeClassAbilityBonusScoringPolicy(WorldCupPointsFactory pointsFactory, int ageClassAbilityScore, boolean includeAbilityClasses) {
        this(ScoringElement.POINTS, pointsFactory, pointsFactory.forPoints(ageClassAbilityScore), includeAbilityClasses, false, false);
    }

    public AgeClassAbilityBonusScoringPolicy(WorldCupPointsFactory pointsFactory, WorldCupPoints<?> ageClassAbilityScore, boolean includeAbilityClasses) {
        this(ScoringElement.POINTS, pointsFactory, ageClassAbilityScore, includeAbilityClasses, false, false);
    }

    public AgeClassAbilityBonusScoringPolicy(WorldCupPointsFactory pointsFactory, WorldCupPoints<?> ageClassAbilityScore, boolean includeAbilityClasses, boolean mustStartAllRaces, boolean mustCompleteAllRaces) {
        this(ScoringElement.POINTS, pointsFactory, ageClassAbilityScore, includeAbilityClasses, mustStartAllRaces, mustCompleteAllRaces);
    }

    protected AgeClassAbilityBonusScoringPolicy(ScoringElement scoringElement, WorldCupPointsFactory pointsFactory, WorldCupPoints<?> ageClassAbilityScore, boolean includeAbilityClasses, boolean mustStartAllRaces, boolean mustCompleteAllRaces) {
        super(scoringElement, mustStartAllRaces, mustCompleteAllRaces);
        if (scoringElement != ScoringElement.POINTS) {
            throw new IllegalArgumentException("Open seed bonus policy only applies for World Cup points scoring");
        }
        this.pointsFactory = pointsFactory;
        this.initAgeClassAbilityBonusResult(ageClassAbilityScore);
        this.includeAbilityClasses = includeAbilityClasses;
    }

    protected void allocateAgeClassPointsForAbilityClassRacers(RaceClass<?> anAbilityClass) {
        int nRaces = this.getResultsData().getNumberOfRaces();
        CategoryResultsList abilityClassResultsList = this.getResultsData().getCategoryResults(anAbilityClass);
        if (abilityClassResultsList == null) {
            return;
        }
        for (RaceSeriesResult abilityClassResults : abilityClassResultsList) {
            Racer theRacer = abilityClassResults.getRacer();
            RaceClass<?> ageClass = theRacer.getAgeClass();
            RaceSeriesResult ageClassResults = this.getResultsData().findOrCreateSeriesResult(theRacer.getBib(), ageClass, ageClass);
            if (ageClassResults.getPoints() == null) {
                ageClassResults.setPoints(this.pointsFactory.zero());
            }
            for (int raceIndex = 0; raceIndex < nRaces; ++raceIndex) {
                RaceStartResult abilityClassStart = abilityClassResults.getStartResult(raceIndex);
                if (abilityClassStart == null) continue;
                if (ageClassResults.getStartResult(raceIndex) != null) {
                    throw new IllegalStateException("Age class ability bonus scoring error: age class result already stored for " + theRacer.getLastName() + "(" + ageClass.name + ") - race " + raceIndex);
                }
                ageClassResults.putSpecialResult(raceIndex, this.ageClassAbilityBonusResult);
                this.addPoints(ageClassResults, this.ageClassAbilityBonusResult.getPoints());
            }
            this.completeAgeClassAbilityResultsUpdate(ageClassResults, abilityClassResults);
        }
        if (!this.includeAbilityClasses) {
            this.getResultsData().removeCategoryResults(anAbilityClass);
        }
    }

    protected void completeAgeClassAbilityResultsUpdate(RaceSeriesResult ageClassResults, RaceSeriesResult abilityClassResults) {
        if (!this.includeAbilityClasses) {
            ageClassResults.incrementNumberOfStarts(abilityClassResults.getNumberOfStarts());
            ageClassResults.incrementNumberOfFinishes(abilityClassResults.getNumberOfFinishes());
        }
    }

    @Override
    protected void computeSeriesTotals() {
        super.computeSeriesTotals();
        this.allocateAgeClassPointsForAbilityClassRacers(this.mensAbilityClass);
        this.allocateAgeClassPointsForAbilityClassRacers(this.womensAbilityClass);
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
        Integer bonusValue = (Integer)policySpec.getParameter(PARM_BONUS_VALUE);
        if (bonusValue != null && bonusValue.intValue() != this.ageClassAbilityBonusResult.getPoints().intValue()) {
            this.initAgeClassAbilityBonusResult(this.pointsFactory.forPoints(bonusValue));
        }
    }

    protected void initAgeClassAbilityBonusResult(WorldCupPoints<?> ageClassAbilityScore) {
        this.ageClassAbilityBonusResult = ageClassAbilityScore == null || ageClassAbilityScore == DEFAULT_AGE_CLASS_ABILITY_SCORE ? DEFAULT_AGE_CLASS_ABILITY_SCORE_RESULT : AgeClassAbilityBonusScoringPolicy.constructAgeClassAbilityBonusResult(ageClassAbilityScore);
    }

    @Override
    protected String getScoringQualificationDescription() {
        return super.getScoringQualificationDescription() + this.getAbilityBonusQualificationDescription();
    }

    protected String getAbilityBonusQualificationDescription() {
        return String.format(" (%s bonus points awarded in age class for ability class results)", this.ageClassAbilityBonusResult.getPoints().intValue());
    }

    @Override
    public String name() {
        return "AgeClassAbilityBonusScoring";
    }

    @Override
    protected void setResultsData(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        super.setResultsData(seriesResultsData);
        Class<RaceClass<?>> raceClassClass = this.getSeriesRaceClass();
        RaceClass<?>[] abilityClasses = RaceClass.getAbilityGroupClassConstants(raceClassClass);
        if (abilityClasses == null) {
            throw new IllegalArgumentException("No ability classes defined for race class " + raceClassClass.getSimpleName());
        }
        this.womensAbilityClass = abilityClasses[Gender.WOMEN.ord];
        this.mensAbilityClass = abilityClasses[Gender.MEN.ord];
    }
}

