/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.RacerResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.ScoringResult;
import org.ussamasters.aces.racedata.models.ScoringValue;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.ScoringElementAccessor;

public abstract class BasicScoringPolicy {
    private ScoringElement scoringElement;
    private ScoringElementAccessor scoringElementAccessor;

    protected BasicScoringPolicy(ScoringElement scoringElement) {
        this(scoringElement, ScoringElementAccessor.forScoringElement(scoringElement));
    }

    protected BasicScoringPolicy(ScoringElement scoringElement, ScoringElementAccessor scoringElementAccessor) {
        this.scoringElement = scoringElement;
        this.scoringElementAccessor = scoringElementAccessor;
    }

    protected void assignFinishPosition(ScoringResult aResult, int position) {
        aResult.setPosition(position);
        aResult.setTied(false);
    }

    protected void assignFinishPositions(List<? extends RacerResult> categoryResultsList) {
        int position = -1000;
        ScoringValue<?> previousValue = null;
        RacerResult previousResult = null;
        for (int i = 0; i < categoryResultsList.size(); ++i) {
            RacerResult racerResult = categoryResultsList.get(i);
            if (this.isQualifiedForFinishPosition(racerResult)) {
                ScoringValue<?> currentValue = this.getScoringValue(racerResult);
                if (currentValue.equals(previousValue)) {
                    this.assignTie(racerResult, previousResult);
                } else {
                    position = i + 1;
                    this.assignFinishPosition(racerResult, position);
                    previousValue = currentValue;
                }
            } else {
                this.assignNonFinisherPositions(categoryResultsList, i);
                return;
            }
            previousResult = racerResult;
        }
    }

    protected void assignNonFinisherPositions(List<? extends RacerResult> categoryResultsList, int firstNonFinisherIndex) {
        for (int i = firstNonFinisherIndex; i < categoryResultsList.size(); ++i) {
            RacerResult racerResult = categoryResultsList.get(i);
            if (this.isQualifiedForFinishPosition(racerResult)) {
                throw new IllegalStateException("Category results list not sorted by finishers/non-finishers order");
            }
            this.clearFinishPosition(racerResult);
        }
    }

    protected void assignTie(ScoringResult aResult, ScoringResult previousResult) {
        previousResult.setTied(true);
        aResult.setPosition(previousResult.getPosition());
        aResult.setTied(true);
    }

    protected abstract void clearFinishPosition(RacerResult var1);

    protected boolean isQualifiedForFinishPosition(RacerResult racerResult) {
        return racerResult.isFinisher();
    }

    public ScoringElement getScoringElement() {
        return this.scoringElement;
    }

    public ScoringValue<?> getScoringValue(RacerResult racerResult) {
        return this.scoringElementAccessor.getValue(racerResult);
    }

    protected List<RaceStartResult> selectBestNFinishes(int bestNCount, RaceSeriesResult seriesResult) {
        List<RaceStartResult> finishes = new ArrayList<RaceStartResult>();
        for (RaceStartResult racerResult : seriesResult.starts()) {
            if (racerResult == null) continue;
            finishes.add(racerResult);
        }
        this.sortResults(finishes);
        if (finishes.size() > bestNCount) {
            finishes = finishes.subList(0, bestNCount);
        }
        return finishes;
    }

    protected void sortResults(List<? extends RacerResult> resultsList) {
        this.scoringElementAccessor.sortResults(resultsList);
    }

    protected void sortResults(CategoryResultsList<RacerResult> resultsList) {
        this.scoringElementAccessor.sortResults(resultsList);
    }
}

