/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import com.glaivestone.javax.execution.EvaluableAction;
import com.glaivestone.javax.execution.InstanceMethodAction;
import com.glaivestone.javax.lang.ClassX;
import com.glaivestone.javax.lang.ConstantValueWithDescription;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import org.ussamasters.aces.racedata.models.RaceClass;
import org.ussamasters.aces.racedata.models.RaceClassRegistry;
import org.ussamasters.aces.racedata.models.RaceIdentifier;
import org.ussamasters.aces.racedata.models.RaceSeries;
import org.ussamasters.aces.racedata.models.RaceTime;
import org.ussamasters.aces.racedata.models.RaceType;

public class BernardCupHandicapFormula
extends ConstantValueWithDescription<BernardCupHandicapFormula> {
    private static final Class<BernardCupHandicapFormula> THIS_CLASS = BernardCupHandicapFormula.class;
    public static final BernardCupHandicapFormula TEN_YEAR_AGE_CLASS_GS_FORMULA;
    public static final BernardCupHandicapFormula TEN_YEAR_AGE_CLASS_SL_FORMULA;
    public static final BernardCupHandicapFormula FIVE_YEAR_AGE_CLASS_GS_FORMULA;
    public static final BernardCupHandicapFormula FIVE_YEAR_AGE_CLASS_TRIPLE_COMBINED_FORMULA;
    public static final BernardCupHandicapFormula FIVE_YEAR_AGE_CLASS_SL_FORMULA;
    protected static final int UNSCORED_AGE_CLASS_INDEX = -1;
    protected static final RaceTime UNSCORED_AGE_CLASS_ADJUSTED_TIME;
    public static final int FIVE_YEAR_AGE_RANGE = 5;
    public static final int TEN_YEAR_AGE_RANGE = 10;
    protected static final Class<?>[] COMPUTE_AGE_CLASS_INDEX_PARM_TYPES;
    protected static final Method COMPUTE_AGE_CLASS_INDEX_FIVE_YEAR_METHOD;
    protected static final Method COMPUTE_AGE_CLASS_INDEX_TEN_YEAR_METHOD;
    protected final int ageClassAgeRange;
    protected final float ageFactor;
    protected final EvaluableAction computeAgeClassIndexAction;

    public static BernardCupHandicapFormula defineConstant(String name, String description, int ageClassAgeRange, float ageFactor) {
        BernardCupHandicapFormula existingConstant = BernardCupHandicapFormula.getConstant(name);
        if (existingConstant != null) {
            return existingConstant;
        }
        return new BernardCupHandicapFormula(name, description, ageClassAgeRange, ageFactor);
    }

    public static BernardCupHandicapFormula formulaForName(String formulaName) {
        return BernardCupHandicapFormula.getConstant(formulaName);
    }

    public static BernardCupHandicapFormula formulaForSeries(RaceSeries raceSeries) {
        HashSet<RaceType> raceTypes = new HashSet<RaceType>();
        for (RaceIdentifier race : raceSeries.getRaces()) {
            raceTypes.add(race.getType());
        }
        int nRaceTypes = raceTypes.size();
        RaceType raceTypeBasis = null;
        if (nRaceTypes == 1) {
            raceTypeBasis = (RaceType)raceTypes.iterator().next();
        } else if (nRaceTypes == 3 && raceTypes.contains(RaceType.SG) && raceTypes.contains(RaceType.GS) && raceTypes.contains(RaceType.SL) || nRaceTypes == 2 && raceTypes.contains(RaceType.SG) && raceTypes.contains(RaceType.GS)) {
            raceTypeBasis = RaceType.GS;
        }
        if (raceTypeBasis == null) {
            throw new IllegalArgumentException("Bernard Cup scoring formula not defined for this race series");
        }
        Class<? extends RaceClass<?>> ageClassClass = raceSeries.getRaceClassClass();
        int ageClassAgeRange = RaceClassRegistry.current().getAgeRange(ageClassClass);
        switch (ageClassAgeRange) {
            case 5: {
                if (raceTypeBasis == RaceType.GS) {
                    return FIVE_YEAR_AGE_CLASS_GS_FORMULA;
                }
                if (raceTypeBasis != RaceType.SL) break;
                return FIVE_YEAR_AGE_CLASS_SL_FORMULA;
            }
            case 10: {
                if (raceTypeBasis == RaceType.GS) {
                    return TEN_YEAR_AGE_CLASS_GS_FORMULA;
                }
                if (raceTypeBasis != RaceType.SL) break;
                return TEN_YEAR_AGE_CLASS_SL_FORMULA;
            }
        }
        throw new IllegalArgumentException("Bernard Cup scoring formula not defined for " + ageClassClass);
    }

    protected static Method getComputeAgeClassIndexMethod(int ageClassAgeRange) {
        switch (ageClassAgeRange) {
            case 5: {
                return COMPUTE_AGE_CLASS_INDEX_FIVE_YEAR_METHOD;
            }
            case 10: {
                return COMPUTE_AGE_CLASS_INDEX_TEN_YEAR_METHOD;
            }
        }
        throw new IllegalArgumentException("Unsupported race class age range: " + ageClassAgeRange);
    }

    public static BernardCupHandicapFormula getConstant(int ordinalValue) {
        return BernardCupHandicapFormula.getConstant(ordinalValue, THIS_CLASS);
    }

    public static BernardCupHandicapFormula getConstant(String name) {
        return BernardCupHandicapFormula.getConstant(name, THIS_CLASS);
    }

    public static List<BernardCupHandicapFormula> values() {
        return BernardCupHandicapFormula.values(THIS_CLASS);
    }

    protected BernardCupHandicapFormula(String name, String description, Class<? extends RaceClass<?>> raceClassClass, float ageFactor) {
        this(name, description, RaceClassRegistry.current().getAgeRange(raceClassClass), ageFactor);
    }

    protected BernardCupHandicapFormula(String name, String description, int ageClassAgeRange, float ageFactor) {
        super(name, description);
        this.ageClassAgeRange = ageClassAgeRange;
        this.ageFactor = ageFactor;
        this.computeAgeClassIndexAction = new InstanceMethodAction(this, BernardCupHandicapFormula.getComputeAgeClassIndexMethod(ageClassAgeRange), null, InstanceMethodAction.DEFAULT_HANDLER);
    }

    public RaceTime computeAdjustedTime(RaceTime actualTime, RaceClass<?> ageClass) {
        int ageClassIndex = this.computeAgeClassIndex(ageClass);
        if (ageClassIndex == -1) {
            return UNSCORED_AGE_CLASS_ADJUSTED_TIME;
        }
        float bcTime = actualTime.floatValue() * (1.0f - this.ageFactor * (float)ageClassIndex);
        return RaceTime.fromFloat(bcTime);
    }

    protected int computeAgeClassIndex(RaceClass<?> ageClass) {
        return (Integer)this.computeAgeClassIndexAction.evaluate(ageClass);
    }

    public int computeAgeClassIndex5YearClasses(RaceClass<?> ageClass) {
        int ageClassNumber = ageClass.getClassNumber();
        if (ageClassNumber < 1) {
            return -1;
        }
        return ageClassNumber - 1;
    }

    public int computeAgeClassIndex10YearClasses(RaceClass<?> ageClass) {
        int ageClassStartAge = ageClass.startAge;
        if (ageClassStartAge < 20) {
            return -1;
        }
        return ageClassStartAge / 10 - 2;
    }

    static {
        UNSCORED_AGE_CLASS_ADJUSTED_TIME = RaceTime.fromString("999:00.00");
        COMPUTE_AGE_CLASS_INDEX_PARM_TYPES = new Class[]{RaceClass.class};
        COMPUTE_AGE_CLASS_INDEX_FIVE_YEAR_METHOD = ClassX.getMethodOrNull(THIS_CLASS, "computeAgeClassIndex5YearClasses", COMPUTE_AGE_CLASS_INDEX_PARM_TYPES);
        COMPUTE_AGE_CLASS_INDEX_TEN_YEAR_METHOD = ClassX.getMethodOrNull(THIS_CLASS, "computeAgeClassIndex10YearClasses", COMPUTE_AGE_CLASS_INDEX_PARM_TYPES);
        TEN_YEAR_AGE_CLASS_GS_FORMULA = new BernardCupHandicapFormula("TenYearClassesGSFormula", "5% time reduction per 10-year age class", 10, 0.05f);
        TEN_YEAR_AGE_CLASS_SL_FORMULA = new BernardCupHandicapFormula("TenYearClassesSLFormula", "6% time reduction per 10-year age class", 10, 0.06f);
        FIVE_YEAR_AGE_CLASS_TRIPLE_COMBINED_FORMULA = new BernardCupHandicapFormula("FiveYearClassesTripleCombinedFormula", "2.5% time reduction per 5-year age class", 5, 0.025f);
        FIVE_YEAR_AGE_CLASS_GS_FORMULA = new BernardCupHandicapFormula("FiveYearClassesGSFormula", "2.5% time reduction per 5-year age class", 5, 0.025f);
        FIVE_YEAR_AGE_CLASS_SL_FORMULA = new BernardCupHandicapFormula("FiveYearClassesSLFormula", "3% time reduction per 5-year age class", 5, 0.03f);
    }
}

