/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.List;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.RaceStartResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.ScoringPolicySpecification;
import org.ussamasters.aces.racedata.scoring.SeriesStandingsScoringPolicy;
import org.ussamasters.aces.racedata.scoring.StandardSeriesScoringPolicy;

public class BestNFinishesScoringPolicy
extends StandardSeriesScoringPolicy {
    private int bestNCount;

    public static SeriesStandingsScoringPolicy forElement(ScoringElement scoringElement) {
        throw new UnsupportedOperationException("Must specify the number of finishes eligeable for scoring");
    }

    public BestNFinishesScoringPolicy(int bestNCount, ScoringElement scoringElement) {
        this(bestNCount, scoringElement, false, false);
    }

    public BestNFinishesScoringPolicy(int bestNCount, ScoringElement scoringElement, boolean mustStartAllRaces, boolean mustCompleteAllRaces) {
        super(scoringElement, mustStartAllRaces, mustCompleteAllRaces);
        this.bestNCount = bestNCount;
    }

    @Override
    protected void computeSeriesTotals(StandingsCategory category, RaceSeriesResult seriesResult) {
        List<RaceStartResult> finishes = this.selectBestNFinishes(this.bestNCount, seriesResult);
        this.computeSeriesTotals(category, seriesResult, finishes);
    }

    @Override
    public void configureOptions(ScoringPolicySpecification policySpec) {
        Integer maxFinishesToCount = (Integer)policySpec.getParameter("maxFinishes");
        if (maxFinishesToCount != null) {
            this.bestNCount = maxFinishesToCount;
        }
    }

    @Override
    protected String getScoringQualificationDescription() {
        return "best " + this.bestNCount + " finishes";
    }

    @Override
    public String name() {
        return "BestNFinishes";
    }
}

