/*
 * Decompiled with CFR 0.152.
 */
package org.ussamasters.aces.racedata.scoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.ussamasters.aces.racedata.models.DivisionsCupPoints;
import org.ussamasters.aces.racedata.models.DivisionsCupResult;
import org.ussamasters.aces.racedata.models.RaceOrganization;
import org.ussamasters.aces.racedata.models.RaceSeriesResult;
import org.ussamasters.aces.racedata.models.ScoringElement;
import org.ussamasters.aces.racedata.models.StandingsCategory;
import org.ussamasters.aces.racedata.scoring.BasicRaceSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.CategoryResultsList;
import org.ussamasters.aces.racedata.scoring.DivisionsCupSeriesResultsOrganizer;
import org.ussamasters.aces.racedata.scoring.StandardSeriesScoringPolicy;

public class DivisionsCupScoringPolicy
extends StandardSeriesScoringPolicy {
    public static final ScoringElement DIVISIONS_CUP_SCORING_ELEMENT = ScoringElement.DIVISIONS_CUP_POINTS;
    public static final Comparator<DivisionsCupResult> DIVISION_RESULT_SORTER = new Comparator<DivisionsCupResult>(){

        @Override
        public int compare(DivisionsCupResult result1, DivisionsCupResult result2) {
            return result1.compareTo(result2);
        }
    };

    public DivisionsCupScoringPolicy() {
        super(DIVISIONS_CUP_SCORING_ELEMENT, false, false);
    }

    protected void assignDivisionFinishPositions(List<DivisionsCupResult> divisionResultsList) {
        int position = -1000;
        DivisionsCupPoints previousValue = null;
        DivisionsCupResult previousResult = null;
        for (int i = 0; i < divisionResultsList.size(); ++i) {
            DivisionsCupResult aResult = divisionResultsList.get(i);
            if (aResult.isQualified()) {
                DivisionsCupPoints currentValue = aResult.getDivisionsCupPoints();
                if (currentValue.equals(previousValue)) {
                    this.assignTie(aResult, previousResult);
                } else {
                    position = i + 1;
                    this.assignFinishPosition(aResult, position);
                    previousValue = currentValue;
                }
            } else {
                this.assignDivisionNonFinisherPositions(divisionResultsList, i);
                return;
            }
            previousResult = aResult;
        }
    }

    protected void assignDivisionNonFinisherPositions(List<DivisionsCupResult> divisionResultsList, int firstNonFinisherIndex) {
        for (int i = firstNonFinisherIndex; i < divisionResultsList.size(); ++i) {
            DivisionsCupResult aResult = divisionResultsList.get(i);
            if (aResult.isQualified()) {
                throw new IllegalStateException("Division results list not sorted by qualified/non-qualified order");
            }
            aResult.clearPosition();
        }
    }

    protected void computeDivisionTotals() {
        int i;
        int i2;
        DivisionsCupSeriesResultsOrganizer myResultsData = (DivisionsCupSeriesResultsOrganizer)this.getResultsData();
        int nOrganizations = RaceOrganization.values().size();
        int[] nDivisionRacers = new int[nOrganizations];
        int[] nDivisionStarts = new int[nOrganizations];
        int[] nDivisionPoints = new int[nOrganizations];
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionRacers[i2] = 0;
        }
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionStarts[i2] = 0;
        }
        for (i2 = 0; i2 < nOrganizations; ++i2) {
            nDivisionPoints[i2] = 0;
        }
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            CategoryResultsList categoryResultsList = myResultsData.getCategoryResults(affiliation);
            if (categoryResultsList == null) continue;
            i = affiliation.ord;
            for (RaceSeriesResult seriesResult : categoryResultsList) {
                int n = i;
                nDivisionRacers[n] = nDivisionRacers[n] + 1;
                nDivisionStarts[i] = nDivisionStarts[i] + seriesResult.getNumberOfStarts();
                nDivisionPoints[i] = nDivisionPoints[i] + seriesResult.getDivisionsCupPoints().intValue();
            }
        }
        ArrayList<DivisionsCupResult> divisionResultsList = new ArrayList<DivisionsCupResult>();
        for (StandingsCategory category : myResultsData.getCategories()) {
            RaceOrganization affiliation = (RaceOrganization)category;
            i = affiliation.ord;
            if (nDivisionRacers[i] <= 0) continue;
            DivisionsCupResult aResult = new DivisionsCupResult(affiliation, nDivisionRacers[i], nDivisionStarts[i], DivisionsCupPoints.forPoints(nDivisionPoints[i]));
            divisionResultsList.add(aResult);
        }
        Collections.sort(divisionResultsList, DIVISION_RESULT_SORTER);
        this.assignDivisionFinishPositions(divisionResultsList);
        myResultsData.setDivisionResults(divisionResultsList);
    }

    @Override
    public void computeStandings(BasicRaceSeriesResultsOrganizer seriesResultsData) {
        super.computeStandings(seriesResultsData);
        this.computeDivisionTotals();
    }

    @Override
    public String name() {
        return "DivisionsCup";
    }
}

